package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.memorydb.model.primitives.UserName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ACLPendingChanges(
    userNamesToRemove: Optional[Iterable[UserName]] = Optional.Absent,
    userNamesToAdd: Optional[Iterable[UserName]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ACLPendingChanges = {
    import ACLPendingChanges.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ACLPendingChanges
      .builder()
      .optionallyWith(
        userNamesToRemove.map(value =>
          value.map { item =>
            UserName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userNamesToRemove)
      .optionallyWith(
        userNamesToAdd.map(value =>
          value.map { item =>
            UserName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userNamesToAdd)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.ACLPendingChanges.ReadOnly =
    zio.aws.memorydb.model.ACLPendingChanges.wrap(buildAwsValue())
}
object ACLPendingChanges {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ACLPendingChanges
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.ACLPendingChanges =
      zio.aws.memorydb.model.ACLPendingChanges(
        userNamesToRemove.map(value => value),
        userNamesToAdd.map(value => value)
      )
    def userNamesToRemove: Optional[List[UserName]]
    def userNamesToAdd: Optional[List[UserName]]
    def getUserNamesToRemove: ZIO[Any, AwsError, List[UserName]] =
      AwsError.unwrapOptionField("userNamesToRemove", userNamesToRemove)
    def getUserNamesToAdd: ZIO[Any, AwsError, List[UserName]] =
      AwsError.unwrapOptionField("userNamesToAdd", userNamesToAdd)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ACLPendingChanges
  ) extends zio.aws.memorydb.model.ACLPendingChanges.ReadOnly {
    override val userNamesToRemove: Optional[List[UserName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userNamesToRemove())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.memorydb.model.primitives.UserName(item)
          }.toList
        )
    override val userNamesToAdd: Optional[List[UserName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userNamesToAdd())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.memorydb.model.primitives.UserName(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ACLPendingChanges
  ): zio.aws.memorydb.model.ACLPendingChanges.ReadOnly = new Wrapper(impl)
}
