package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.memorydb.model.primitives.ACLName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class User(
    name: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    accessString: Optional[String] = Optional.Absent,
    aclNames: Optional[Iterable[ACLName]] = Optional.Absent,
    minimumEngineVersion: Optional[String] = Optional.Absent,
    authentication: Optional[zio.aws.memorydb.model.Authentication] =
      Optional.Absent,
    arn: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.memorydb.model.User = {
    import User.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.User
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(accessString.map(value => value: java.lang.String))(
        _.accessString
      )
      .optionallyWith(
        aclNames.map(value =>
          value.map { item =>
            ACLName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.aclNames)
      .optionallyWith(
        minimumEngineVersion.map(value => value: java.lang.String)
      )(_.minimumEngineVersion)
      .optionallyWith(authentication.map(value => value.buildAwsValue()))(
        _.authentication
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.User.ReadOnly =
    zio.aws.memorydb.model.User.wrap(buildAwsValue())
}
object User {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.memorydb.model.User] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.User = zio.aws.memorydb.model.User(
      name.map(value => value),
      status.map(value => value),
      accessString.map(value => value),
      aclNames.map(value => value),
      minimumEngineVersion.map(value => value),
      authentication.map(value => value.asEditable),
      arn.map(value => value)
    )
    def name: Optional[String]
    def status: Optional[String]
    def accessString: Optional[String]
    def aclNames: Optional[List[ACLName]]
    def minimumEngineVersion: Optional[String]
    def authentication: Optional[zio.aws.memorydb.model.Authentication.ReadOnly]
    def arn: Optional[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getAccessString: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accessString", accessString)
    def getAclNames: ZIO[Any, AwsError, List[ACLName]] =
      AwsError.unwrapOptionField("aclNames", aclNames)
    def getMinimumEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("minimumEngineVersion", minimumEngineVersion)
    def getAuthentication
        : ZIO[Any, AwsError, zio.aws.memorydb.model.Authentication.ReadOnly] =
      AwsError.unwrapOptionField("authentication", authentication)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.User
  ) extends zio.aws.memorydb.model.User.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val accessString: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.accessString())
      .map(value => value: String)
    override val aclNames: Optional[List[ACLName]] = zio.aws.core.internal
      .optionalFromNullable(impl.aclNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.memorydb.model.primitives.ACLName(item)
        }.toList
      )
    override val minimumEngineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.minimumEngineVersion())
      .map(value => value: String)
    override val authentication
        : Optional[zio.aws.memorydb.model.Authentication.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authentication())
        .map(value => zio.aws.memorydb.model.Authentication.wrap(value))
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.User
  ): zio.aws.memorydb.model.User.ReadOnly = new Wrapper(impl)
}
