package zio.aws.memorydb.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.memorydb.model.primitives.TStamp
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Event(
    sourceName: Optional[String] = Optional.Absent,
    sourceType: Optional[zio.aws.memorydb.model.SourceType] = Optional.Absent,
    message: Optional[String] = Optional.Absent,
    date: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.memorydb.model.Event = {
    import Event.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.Event
      .builder()
      .optionallyWith(sourceName.map(value => value: java.lang.String))(
        _.sourceName
      )
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(date.map(value => TStamp.unwrap(value): Instant))(_.date)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.Event.ReadOnly =
    zio.aws.memorydb.model.Event.wrap(buildAwsValue())
}
object Event {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.memorydb.model.Event] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.Event = zio.aws.memorydb.model.Event(
      sourceName.map(value => value),
      sourceType.map(value => value),
      message.map(value => value),
      date.map(value => value)
    )
    def sourceName: Optional[String]
    def sourceType: Optional[zio.aws.memorydb.model.SourceType]
    def message: Optional[String]
    def date: Optional[TStamp]
    def getSourceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceName", sourceName)
    def getSourceType: ZIO[Any, AwsError, zio.aws.memorydb.model.SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("date", date)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.Event
  ) extends zio.aws.memorydb.model.Event.ReadOnly {
    override val sourceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceName())
      .map(value => value: String)
    override val sourceType: Optional[zio.aws.memorydb.model.SourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceType())
        .map(value => zio.aws.memorydb.model.SourceType.wrap(value))
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
    override val date: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.date())
      .map(value => zio.aws.memorydb.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.Event
  ): zio.aws.memorydb.model.Event.ReadOnly = new Wrapper(impl)
}
