package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.memorydb.model.primitives.UserName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ACL(
    name: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    userNames: Optional[Iterable[UserName]] = Optional.Absent,
    minimumEngineVersion: Optional[String] = Optional.Absent,
    pendingChanges: Optional[zio.aws.memorydb.model.ACLPendingChanges] =
      Optional.Absent,
    clusters: Optional[Iterable[String]] = Optional.Absent,
    arn: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.memorydb.model.ACL = {
    import ACL.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ACL
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        userNames.map(value =>
          value.map { item =>
            UserName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userNames)
      .optionallyWith(
        minimumEngineVersion.map(value => value: java.lang.String)
      )(_.minimumEngineVersion)
      .optionallyWith(pendingChanges.map(value => value.buildAwsValue()))(
        _.pendingChanges
      )
      .optionallyWith(
        clusters.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.clusters)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.ACL.ReadOnly =
    zio.aws.memorydb.model.ACL.wrap(buildAwsValue())
}
object ACL {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.memorydb.model.ACL] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.ACL = zio.aws.memorydb.model.ACL(
      name.map(value => value),
      status.map(value => value),
      userNames.map(value => value),
      minimumEngineVersion.map(value => value),
      pendingChanges.map(value => value.asEditable),
      clusters.map(value => value),
      arn.map(value => value)
    )
    def name: Optional[String]
    def status: Optional[String]
    def userNames: Optional[List[UserName]]
    def minimumEngineVersion: Optional[String]
    def pendingChanges
        : Optional[zio.aws.memorydb.model.ACLPendingChanges.ReadOnly]
    def clusters: Optional[List[String]]
    def arn: Optional[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getUserNames: ZIO[Any, AwsError, List[UserName]] =
      AwsError.unwrapOptionField("userNames", userNames)
    def getMinimumEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("minimumEngineVersion", minimumEngineVersion)
    def getPendingChanges: ZIO[
      Any,
      AwsError,
      zio.aws.memorydb.model.ACLPendingChanges.ReadOnly
    ] = AwsError.unwrapOptionField("pendingChanges", pendingChanges)
    def getClusters: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("clusters", clusters)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ACL
  ) extends zio.aws.memorydb.model.ACL.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val userNames: Optional[List[UserName]] = zio.aws.core.internal
      .optionalFromNullable(impl.userNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.memorydb.model.primitives.UserName(item)
        }.toList
      )
    override val minimumEngineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.minimumEngineVersion())
      .map(value => value: String)
    override val pendingChanges
        : Optional[zio.aws.memorydb.model.ACLPendingChanges.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pendingChanges())
        .map(value => zio.aws.memorydb.model.ACLPendingChanges.wrap(value))
    override val clusters: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.clusters())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ACL
  ): zio.aws.memorydb.model.ACL.ReadOnly = new Wrapper(impl)
}
