package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchUpdateClusterRequest(
    clusterNames: Iterable[String],
    serviceUpdate: Optional[zio.aws.memorydb.model.ServiceUpdateRequest] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterRequest = {
    import BatchUpdateClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterRequest
      .builder()
      .clusterNames(clusterNames.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(serviceUpdate.map(value => value.buildAwsValue()))(
        _.serviceUpdate
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.BatchUpdateClusterRequest.ReadOnly =
    zio.aws.memorydb.model.BatchUpdateClusterRequest.wrap(buildAwsValue())
}
object BatchUpdateClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.BatchUpdateClusterRequest =
      zio.aws.memorydb.model.BatchUpdateClusterRequest(
        clusterNames,
        serviceUpdate.map(value => value.asEditable)
      )
    def clusterNames: List[String]
    def serviceUpdate
        : Optional[zio.aws.memorydb.model.ServiceUpdateRequest.ReadOnly]
    def getClusterNames: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(clusterNames)
    def getServiceUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.memorydb.model.ServiceUpdateRequest.ReadOnly
    ] = AwsError.unwrapOptionField("serviceUpdate", serviceUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterRequest
  ) extends zio.aws.memorydb.model.BatchUpdateClusterRequest.ReadOnly {
    override val clusterNames: List[String] = impl
      .clusterNames()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val serviceUpdate
        : Optional[zio.aws.memorydb.model.ServiceUpdateRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceUpdate())
        .map(value => zio.aws.memorydb.model.ServiceUpdateRequest.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterRequest
  ): zio.aws.memorydb.model.BatchUpdateClusterRequest.ReadOnly = new Wrapper(
    impl
  )
}
