package zio.aws.memorydb.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.memorydb.model.primitives.TStamp
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ServiceUpdate(
    clusterName: Optional[String] = Optional.Absent,
    serviceUpdateName: Optional[String] = Optional.Absent,
    releaseDate: Optional[TStamp] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.memorydb.model.ServiceUpdateStatus] =
      Optional.Absent,
    `type`: Optional[zio.aws.memorydb.model.ServiceUpdateType] =
      Optional.Absent,
    nodesUpdated: Optional[String] = Optional.Absent,
    autoUpdateStartDate: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ServiceUpdate = {
    import ServiceUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ServiceUpdate
      .builder()
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(serviceUpdateName.map(value => value: java.lang.String))(
        _.serviceUpdateName
      )
      .optionallyWith(releaseDate.map(value => TStamp.unwrap(value): Instant))(
        _.releaseDate
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(nodesUpdated.map(value => value: java.lang.String))(
        _.nodesUpdated
      )
      .optionallyWith(
        autoUpdateStartDate.map(value => TStamp.unwrap(value): Instant)
      )(_.autoUpdateStartDate)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.ServiceUpdate.ReadOnly =
    zio.aws.memorydb.model.ServiceUpdate.wrap(buildAwsValue())
}
object ServiceUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ServiceUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.ServiceUpdate =
      zio.aws.memorydb.model.ServiceUpdate(
        clusterName.map(value => value),
        serviceUpdateName.map(value => value),
        releaseDate.map(value => value),
        description.map(value => value),
        status.map(value => value),
        `type`.map(value => value),
        nodesUpdated.map(value => value),
        autoUpdateStartDate.map(value => value)
      )
    def clusterName: Optional[String]
    def serviceUpdateName: Optional[String]
    def releaseDate: Optional[TStamp]
    def description: Optional[String]
    def status: Optional[zio.aws.memorydb.model.ServiceUpdateStatus]
    def `type`: Optional[zio.aws.memorydb.model.ServiceUpdateType]
    def nodesUpdated: Optional[String]
    def autoUpdateStartDate: Optional[TStamp]
    def getClusterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getServiceUpdateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceUpdateName", serviceUpdateName)
    def getReleaseDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("releaseDate", releaseDate)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.memorydb.model.ServiceUpdateStatus] =
      AwsError.unwrapOptionField("status", status)
    def getType: ZIO[Any, AwsError, zio.aws.memorydb.model.ServiceUpdateType] =
      AwsError.unwrapOptionField("type", `type`)
    def getNodesUpdated: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodesUpdated", nodesUpdated)
    def getAutoUpdateStartDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("autoUpdateStartDate", autoUpdateStartDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ServiceUpdate
  ) extends zio.aws.memorydb.model.ServiceUpdate.ReadOnly {
    override val clusterName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterName())
      .map(value => value: String)
    override val serviceUpdateName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceUpdateName())
      .map(value => value: String)
    override val releaseDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.releaseDate())
      .map(value => zio.aws.memorydb.model.primitives.TStamp(value))
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val status: Optional[zio.aws.memorydb.model.ServiceUpdateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.memorydb.model.ServiceUpdateStatus.wrap(value))
    override val `type`: Optional[zio.aws.memorydb.model.ServiceUpdateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.memorydb.model.ServiceUpdateType.wrap(value))
    override val nodesUpdated: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodesUpdated())
      .map(value => value: String)
    override val autoUpdateStartDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.autoUpdateStartDate())
      .map(value => zio.aws.memorydb.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ServiceUpdate
  ): zio.aws.memorydb.model.ServiceUpdate.ReadOnly = new Wrapper(impl)
}
