package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteSnapshotRequest(snapshotName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DeleteSnapshotRequest = {
    import DeleteSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DeleteSnapshotRequest
      .builder()
      .snapshotName(snapshotName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.DeleteSnapshotRequest.ReadOnly =
    zio.aws.memorydb.model.DeleteSnapshotRequest.wrap(buildAwsValue())
}
object DeleteSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DeleteSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DeleteSnapshotRequest =
      zio.aws.memorydb.model.DeleteSnapshotRequest(snapshotName)
    def snapshotName: String
    def getSnapshotName: ZIO[Any, Nothing, String] = ZIO.succeed(snapshotName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteSnapshotRequest
  ) extends zio.aws.memorydb.model.DeleteSnapshotRequest.ReadOnly {
    override val snapshotName: String = impl.snapshotName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteSnapshotRequest
  ): zio.aws.memorydb.model.DeleteSnapshotRequest.ReadOnly = new Wrapper(impl)
}
