package zio.aws.memorydb.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.memorydb.model.primitives.{
  ACLName,
  BooleanOptional,
  IntegerOptional
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateClusterRequest(
    clusterName: String,
    nodeType: String,
    parameterGroupName: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    numShards: Optional[IntegerOptional] = Optional.Absent,
    numReplicasPerShard: Optional[IntegerOptional] = Optional.Absent,
    subnetGroupName: Optional[String] = Optional.Absent,
    securityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    maintenanceWindow: Optional[String] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    snsTopicArn: Optional[String] = Optional.Absent,
    tlsEnabled: Optional[BooleanOptional] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    snapshotArns: Optional[Iterable[String]] = Optional.Absent,
    snapshotName: Optional[String] = Optional.Absent,
    snapshotRetentionLimit: Optional[IntegerOptional] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.memorydb.model.Tag]] = Optional.Absent,
    snapshotWindow: Optional[String] = Optional.Absent,
    aclName: ACLName,
    engineVersion: Optional[String] = Optional.Absent,
    autoMinorVersionUpgrade: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.CreateClusterRequest = {
    import CreateClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.CreateClusterRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .nodeType(nodeType: java.lang.String)
      .optionallyWith(parameterGroupName.map(value => value: java.lang.String))(
        _.parameterGroupName
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(numShards.map(value => value: Integer))(_.numShards)
      .optionallyWith(numReplicasPerShard.map(value => value: Integer))(
        _.numReplicasPerShard
      )
      .optionallyWith(subnetGroupName.map(value => value: java.lang.String))(
        _.subnetGroupName
      )
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(maintenanceWindow.map(value => value: java.lang.String))(
        _.maintenanceWindow
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(snsTopicArn.map(value => value: java.lang.String))(
        _.snsTopicArn
      )
      .optionallyWith(tlsEnabled.map(value => value: java.lang.Boolean))(
        _.tlsEnabled
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        snapshotArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.snapshotArns)
      .optionallyWith(snapshotName.map(value => value: java.lang.String))(
        _.snapshotName
      )
      .optionallyWith(snapshotRetentionLimit.map(value => value: Integer))(
        _.snapshotRetentionLimit
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(snapshotWindow.map(value => value: java.lang.String))(
        _.snapshotWindow
      )
      .aclName(ACLName.unwrap(aclName): java.lang.String)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.CreateClusterRequest.ReadOnly =
    zio.aws.memorydb.model.CreateClusterRequest.wrap(buildAwsValue())
}
object CreateClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.CreateClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.CreateClusterRequest =
      zio.aws.memorydb.model.CreateClusterRequest(
        clusterName,
        nodeType,
        parameterGroupName.map(value => value),
        description.map(value => value),
        numShards.map(value => value),
        numReplicasPerShard.map(value => value),
        subnetGroupName.map(value => value),
        securityGroupIds.map(value => value),
        maintenanceWindow.map(value => value),
        port.map(value => value),
        snsTopicArn.map(value => value),
        tlsEnabled.map(value => value),
        kmsKeyId.map(value => value),
        snapshotArns.map(value => value),
        snapshotName.map(value => value),
        snapshotRetentionLimit.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        snapshotWindow.map(value => value),
        aclName,
        engineVersion.map(value => value),
        autoMinorVersionUpgrade.map(value => value)
      )
    def clusterName: String
    def nodeType: String
    def parameterGroupName: Optional[String]
    def description: Optional[String]
    def numShards: Optional[IntegerOptional]
    def numReplicasPerShard: Optional[IntegerOptional]
    def subnetGroupName: Optional[String]
    def securityGroupIds: Optional[List[String]]
    def maintenanceWindow: Optional[String]
    def port: Optional[IntegerOptional]
    def snsTopicArn: Optional[String]
    def tlsEnabled: Optional[BooleanOptional]
    def kmsKeyId: Optional[String]
    def snapshotArns: Optional[List[String]]
    def snapshotName: Optional[String]
    def snapshotRetentionLimit: Optional[IntegerOptional]
    def tags: Optional[List[zio.aws.memorydb.model.Tag.ReadOnly]]
    def snapshotWindow: Optional[String]
    def aclName: ACLName
    def engineVersion: Optional[String]
    def autoMinorVersionUpgrade: Optional[BooleanOptional]
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getNodeType: ZIO[Any, Nothing, String] = ZIO.succeed(nodeType)
    def getParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getNumShards: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numShards", numShards)
    def getNumReplicasPerShard: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numReplicasPerShard", numReplicasPerShard)
    def getSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetGroupName", subnetGroupName)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceWindow", maintenanceWindow)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getSnsTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getTlsEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("tlsEnabled", tlsEnabled)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getSnapshotArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("snapshotArns", snapshotArns)
    def getSnapshotName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotName", snapshotName)
    def getSnapshotRetentionLimit: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "snapshotRetentionLimit",
        snapshotRetentionLimit
      )
    def getTags: ZIO[Any, AwsError, List[zio.aws.memorydb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSnapshotWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotWindow", snapshotWindow)
    def getAclName: ZIO[Any, Nothing, ACLName] = ZIO.succeed(aclName)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.CreateClusterRequest
  ) extends zio.aws.memorydb.model.CreateClusterRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
    override val nodeType: String = impl.nodeType(): String
    override val parameterGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterGroupName())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val numShards: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.numShards())
      .map(value => value: IntegerOptional)
    override val numReplicasPerShard: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numReplicasPerShard())
        .map(value => value: IntegerOptional)
    override val subnetGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetGroupName())
      .map(value => value: String)
    override val securityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val maintenanceWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maintenanceWindow())
      .map(value => value: String)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val snsTopicArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snsTopicArn())
      .map(value => value: String)
    override val tlsEnabled: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.tlsEnabled())
      .map(value => value: BooleanOptional)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val snapshotArns: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val snapshotName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotName())
      .map(value => value: String)
    override val snapshotRetentionLimit: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotRetentionLimit())
        .map(value => value: IntegerOptional)
    override val tags: Optional[List[zio.aws.memorydb.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.memorydb.model.Tag.wrap(item)
          }.toList
        )
    override val snapshotWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotWindow())
      .map(value => value: String)
    override val aclName: ACLName =
      zio.aws.memorydb.model.primitives.ACLName(impl.aclName())
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val autoMinorVersionUpgrade: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMinorVersionUpgrade())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.CreateClusterRequest
  ): zio.aws.memorydb.model.CreateClusterRequest.ReadOnly = new Wrapper(impl)
}
