package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateParameterGroupResponse(
    parameterGroup: Optional[zio.aws.memorydb.model.ParameterGroup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.CreateParameterGroupResponse = {
    import CreateParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.CreateParameterGroupResponse
      .builder()
      .optionallyWith(parameterGroup.map(value => value.buildAwsValue()))(
        _.parameterGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.CreateParameterGroupResponse.ReadOnly =
    zio.aws.memorydb.model.CreateParameterGroupResponse.wrap(buildAwsValue())
}
object CreateParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.CreateParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.CreateParameterGroupResponse =
      zio.aws.memorydb.model.CreateParameterGroupResponse(
        parameterGroup.map(value => value.asEditable)
      )
    def parameterGroup: Optional[zio.aws.memorydb.model.ParameterGroup.ReadOnly]
    def getParameterGroup
        : ZIO[Any, AwsError, zio.aws.memorydb.model.ParameterGroup.ReadOnly] =
      AwsError.unwrapOptionField("parameterGroup", parameterGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.CreateParameterGroupResponse
  ) extends zio.aws.memorydb.model.CreateParameterGroupResponse.ReadOnly {
    override val parameterGroup
        : Optional[zio.aws.memorydb.model.ParameterGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterGroup())
        .map(value => zio.aws.memorydb.model.ParameterGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.CreateParameterGroupResponse
  ): zio.aws.memorydb.model.CreateParameterGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
