package zio.aws.memorydb.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.memorydb.model.primitives.IntegerOptional
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeParametersRequest(
    parameterGroupName: String,
    maxResults: Optional[IntegerOptional] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeParametersRequest = {
    import DescribeParametersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeParametersRequest
      .builder()
      .parameterGroupName(parameterGroupName: java.lang.String)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.DescribeParametersRequest.ReadOnly =
    zio.aws.memorydb.model.DescribeParametersRequest.wrap(buildAwsValue())
}
object DescribeParametersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeParametersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DescribeParametersRequest =
      zio.aws.memorydb.model.DescribeParametersRequest(
        parameterGroupName,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def parameterGroupName: String
    def maxResults: Optional[IntegerOptional]
    def nextToken: Optional[String]
    def getParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(parameterGroupName)
    def getMaxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeParametersRequest
  ) extends zio.aws.memorydb.model.DescribeParametersRequest.ReadOnly {
    override val parameterGroupName: String = impl.parameterGroupName(): String
    override val maxResults: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: IntegerOptional)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeParametersRequest
  ): zio.aws.memorydb.model.DescribeParametersRequest.ReadOnly = new Wrapper(
    impl
  )
}
