package zio.aws.memorydb.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.memorydb.model.primitives.{BooleanOptional, IntegerOptional}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeClustersRequest(
    clusterName: Optional[String] = Optional.Absent,
    maxResults: Optional[IntegerOptional] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    showShardDetails: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeClustersRequest = {
    import DescribeClustersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeClustersRequest
      .builder()
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(showShardDetails.map(value => value: java.lang.Boolean))(
        _.showShardDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.DescribeClustersRequest.ReadOnly =
    zio.aws.memorydb.model.DescribeClustersRequest.wrap(buildAwsValue())
}
object DescribeClustersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeClustersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DescribeClustersRequest =
      zio.aws.memorydb.model.DescribeClustersRequest(
        clusterName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        showShardDetails.map(value => value)
      )
    def clusterName: Optional[String]
    def maxResults: Optional[IntegerOptional]
    def nextToken: Optional[String]
    def showShardDetails: Optional[BooleanOptional]
    def getClusterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getMaxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getShowShardDetails: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("showShardDetails", showShardDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeClustersRequest
  ) extends zio.aws.memorydb.model.DescribeClustersRequest.ReadOnly {
    override val clusterName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterName())
      .map(value => value: String)
    override val maxResults: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: IntegerOptional)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val showShardDetails: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.showShardDetails())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeClustersRequest
  ): zio.aws.memorydb.model.DescribeClustersRequest.ReadOnly = new Wrapper(impl)
}
