package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateParameterGroupRequest(
    parameterGroupName: String,
    parameterNameValues: Iterable[zio.aws.memorydb.model.ParameterNameValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.UpdateParameterGroupRequest = {
    import UpdateParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.UpdateParameterGroupRequest
      .builder()
      .parameterGroupName(parameterGroupName: java.lang.String)
      .parameterNameValues(parameterNameValues.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.UpdateParameterGroupRequest.ReadOnly =
    zio.aws.memorydb.model.UpdateParameterGroupRequest.wrap(buildAwsValue())
}
object UpdateParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.UpdateParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.UpdateParameterGroupRequest =
      zio.aws.memorydb.model.UpdateParameterGroupRequest(
        parameterGroupName,
        parameterNameValues.map { item =>
          item.asEditable
        }
      )
    def parameterGroupName: String
    def parameterNameValues
        : List[zio.aws.memorydb.model.ParameterNameValue.ReadOnly]
    def getParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(parameterGroupName)
    def getParameterNameValues: ZIO[Any, Nothing, List[
      zio.aws.memorydb.model.ParameterNameValue.ReadOnly
    ]] = ZIO.succeed(parameterNameValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateParameterGroupRequest
  ) extends zio.aws.memorydb.model.UpdateParameterGroupRequest.ReadOnly {
    override val parameterGroupName: String = impl.parameterGroupName(): String
    override val parameterNameValues
        : List[zio.aws.memorydb.model.ParameterNameValue.ReadOnly] = impl
      .parameterNameValues()
      .asScala
      .map { item =>
        zio.aws.memorydb.model.ParameterNameValue.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateParameterGroupRequest
  ): zio.aws.memorydb.model.UpdateParameterGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
