package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.memorydb.model.primitives.UserName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteUserRequest(userName: UserName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DeleteUserRequest = {
    import DeleteUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DeleteUserRequest
      .builder()
      .userName(UserName.unwrap(userName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.DeleteUserRequest.ReadOnly =
    zio.aws.memorydb.model.DeleteUserRequest.wrap(buildAwsValue())
}
object DeleteUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DeleteUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DeleteUserRequest =
      zio.aws.memorydb.model.DeleteUserRequest(userName)
    def userName: UserName
    def getUserName: ZIO[Any, Nothing, UserName] = ZIO.succeed(userName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteUserRequest
  ) extends zio.aws.memorydb.model.DeleteUserRequest.ReadOnly {
    override val userName: UserName =
      zio.aws.memorydb.model.primitives.UserName(impl.userName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteUserRequest
  ): zio.aws.memorydb.model.DeleteUserRequest.ReadOnly = new Wrapper(impl)
}
