package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.memorydb.model.primitives.TStamp
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ServiceUpdate(
    clusterName: Option[String] = None,
    serviceUpdateName: Option[String] = None,
    releaseDate: Option[TStamp] = None,
    description: Option[String] = None,
    status: Option[zio.aws.memorydb.model.ServiceUpdateStatus] = None,
    `type`: Option[zio.aws.memorydb.model.ServiceUpdateType] = None,
    nodesUpdated: Option[String] = None,
    autoUpdateStartDate: Option[TStamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ServiceUpdate = {
    import ServiceUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ServiceUpdate
      .builder()
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(serviceUpdateName.map(value => value: java.lang.String))(
        _.serviceUpdateName
      )
      .optionallyWith(releaseDate.map(value => TStamp.unwrap(value): Instant))(
        _.releaseDate
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(nodesUpdated.map(value => value: java.lang.String))(
        _.nodesUpdated
      )
      .optionallyWith(
        autoUpdateStartDate.map(value => TStamp.unwrap(value): Instant)
      )(_.autoUpdateStartDate)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.ServiceUpdate.ReadOnly =
    zio.aws.memorydb.model.ServiceUpdate.wrap(buildAwsValue())
}
object ServiceUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ServiceUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.ServiceUpdate =
      zio.aws.memorydb.model.ServiceUpdate(
        clusterName.map(value => value),
        serviceUpdateName.map(value => value),
        releaseDate.map(value => value),
        description.map(value => value),
        status.map(value => value),
        `type`.map(value => value),
        nodesUpdated.map(value => value),
        autoUpdateStartDate.map(value => value)
      )
    def clusterName: Option[String]
    def serviceUpdateName: Option[String]
    def releaseDate: Option[TStamp]
    def description: Option[String]
    def status: Option[zio.aws.memorydb.model.ServiceUpdateStatus]
    def `type`: Option[zio.aws.memorydb.model.ServiceUpdateType]
    def nodesUpdated: Option[String]
    def autoUpdateStartDate: Option[TStamp]
    def getClusterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getServiceUpdateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceUpdateName", serviceUpdateName)
    def getReleaseDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("releaseDate", releaseDate)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.memorydb.model.ServiceUpdateStatus] =
      AwsError.unwrapOptionField("status", status)
    def getType: ZIO[Any, AwsError, zio.aws.memorydb.model.ServiceUpdateType] =
      AwsError.unwrapOptionField("type", `type`)
    def getNodesUpdated: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodesUpdated", nodesUpdated)
    def getAutoUpdateStartDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("autoUpdateStartDate", autoUpdateStartDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ServiceUpdate
  ) extends zio.aws.memorydb.model.ServiceUpdate.ReadOnly {
    override val clusterName: Option[String] =
      scala.Option(impl.clusterName()).map(value => value: String)
    override val serviceUpdateName: Option[String] =
      scala.Option(impl.serviceUpdateName()).map(value => value: String)
    override val releaseDate: Option[TStamp] = scala
      .Option(impl.releaseDate())
      .map(value => zio.aws.memorydb.model.primitives.TStamp(value))
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val status: Option[zio.aws.memorydb.model.ServiceUpdateStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.memorydb.model.ServiceUpdateStatus.wrap(value))
    override val `type`: Option[zio.aws.memorydb.model.ServiceUpdateType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.memorydb.model.ServiceUpdateType.wrap(value))
    override val nodesUpdated: Option[String] =
      scala.Option(impl.nodesUpdated()).map(value => value: String)
    override val autoUpdateStartDate: Option[TStamp] = scala
      .Option(impl.autoUpdateStartDate())
      .map(value => zio.aws.memorydb.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ServiceUpdate
  ): zio.aws.memorydb.model.ServiceUpdate.ReadOnly = new Wrapper(impl)
}
