package zio.aws.memorydb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.memorydb.model.primitives.{ACLName, IntegerOptional}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateClusterRequest(
    clusterName: String,
    description: Option[String] = None,
    securityGroupIds: Option[Iterable[String]] = None,
    maintenanceWindow: Option[String] = None,
    snsTopicArn: Option[String] = None,
    snsTopicStatus: Option[String] = None,
    parameterGroupName: Option[String] = None,
    snapshotWindow: Option[String] = None,
    snapshotRetentionLimit: Option[IntegerOptional] = None,
    nodeType: Option[String] = None,
    engineVersion: Option[String] = None,
    replicaConfiguration: Option[
      zio.aws.memorydb.model.ReplicaConfigurationRequest
    ] = None,
    shardConfiguration: Option[
      zio.aws.memorydb.model.ShardConfigurationRequest
    ] = None,
    aclName: Option[ACLName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.UpdateClusterRequest = {
    import UpdateClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.UpdateClusterRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(maintenanceWindow.map(value => value: java.lang.String))(
        _.maintenanceWindow
      )
      .optionallyWith(snsTopicArn.map(value => value: java.lang.String))(
        _.snsTopicArn
      )
      .optionallyWith(snsTopicStatus.map(value => value: java.lang.String))(
        _.snsTopicStatus
      )
      .optionallyWith(parameterGroupName.map(value => value: java.lang.String))(
        _.parameterGroupName
      )
      .optionallyWith(snapshotWindow.map(value => value: java.lang.String))(
        _.snapshotWindow
      )
      .optionallyWith(snapshotRetentionLimit.map(value => value: Integer))(
        _.snapshotRetentionLimit
      )
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(replicaConfiguration.map(value => value.buildAwsValue()))(
        _.replicaConfiguration
      )
      .optionallyWith(shardConfiguration.map(value => value.buildAwsValue()))(
        _.shardConfiguration
      )
      .optionallyWith(
        aclName.map(value => ACLName.unwrap(value): java.lang.String)
      )(_.aclName)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.UpdateClusterRequest.ReadOnly =
    zio.aws.memorydb.model.UpdateClusterRequest.wrap(buildAwsValue())
}
object UpdateClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.UpdateClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.UpdateClusterRequest =
      zio.aws.memorydb.model.UpdateClusterRequest(
        clusterName,
        description.map(value => value),
        securityGroupIds.map(value => value),
        maintenanceWindow.map(value => value),
        snsTopicArn.map(value => value),
        snsTopicStatus.map(value => value),
        parameterGroupName.map(value => value),
        snapshotWindow.map(value => value),
        snapshotRetentionLimit.map(value => value),
        nodeType.map(value => value),
        engineVersion.map(value => value),
        replicaConfiguration.map(value => value.asEditable),
        shardConfiguration.map(value => value.asEditable),
        aclName.map(value => value)
      )
    def clusterName: String
    def description: Option[String]
    def securityGroupIds: Option[List[String]]
    def maintenanceWindow: Option[String]
    def snsTopicArn: Option[String]
    def snsTopicStatus: Option[String]
    def parameterGroupName: Option[String]
    def snapshotWindow: Option[String]
    def snapshotRetentionLimit: Option[IntegerOptional]
    def nodeType: Option[String]
    def engineVersion: Option[String]
    def replicaConfiguration
        : Option[zio.aws.memorydb.model.ReplicaConfigurationRequest.ReadOnly]
    def shardConfiguration
        : Option[zio.aws.memorydb.model.ShardConfigurationRequest.ReadOnly]
    def aclName: Option[ACLName]
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceWindow", maintenanceWindow)
    def getSnsTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getSnsTopicStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopicStatus", snsTopicStatus)
    def getParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupName)
    def getSnapshotWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotWindow", snapshotWindow)
    def getSnapshotRetentionLimit: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "snapshotRetentionLimit",
        snapshotRetentionLimit
      )
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getReplicaConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.memorydb.model.ReplicaConfigurationRequest.ReadOnly
    ] = AwsError.unwrapOptionField("replicaConfiguration", replicaConfiguration)
    def getShardConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.memorydb.model.ShardConfigurationRequest.ReadOnly
    ] = AwsError.unwrapOptionField("shardConfiguration", shardConfiguration)
    def getAclName: ZIO[Any, AwsError, ACLName] =
      AwsError.unwrapOptionField("aclName", aclName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateClusterRequest
  ) extends zio.aws.memorydb.model.UpdateClusterRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val securityGroupIds: Option[List[String]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val maintenanceWindow: Option[String] =
      scala.Option(impl.maintenanceWindow()).map(value => value: String)
    override val snsTopicArn: Option[String] =
      scala.Option(impl.snsTopicArn()).map(value => value: String)
    override val snsTopicStatus: Option[String] =
      scala.Option(impl.snsTopicStatus()).map(value => value: String)
    override val parameterGroupName: Option[String] =
      scala.Option(impl.parameterGroupName()).map(value => value: String)
    override val snapshotWindow: Option[String] =
      scala.Option(impl.snapshotWindow()).map(value => value: String)
    override val snapshotRetentionLimit: Option[IntegerOptional] = scala
      .Option(impl.snapshotRetentionLimit())
      .map(value => value: IntegerOptional)
    override val nodeType: Option[String] =
      scala.Option(impl.nodeType()).map(value => value: String)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val replicaConfiguration
        : Option[zio.aws.memorydb.model.ReplicaConfigurationRequest.ReadOnly] =
      scala
        .Option(impl.replicaConfiguration())
        .map(value =>
          zio.aws.memorydb.model.ReplicaConfigurationRequest.wrap(value)
        )
    override val shardConfiguration
        : Option[zio.aws.memorydb.model.ShardConfigurationRequest.ReadOnly] =
      scala
        .Option(impl.shardConfiguration())
        .map(value =>
          zio.aws.memorydb.model.ShardConfigurationRequest.wrap(value)
        )
    override val aclName: Option[ACLName] = scala
      .Option(impl.aclName())
      .map(value => zio.aws.memorydb.model.primitives.ACLName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateClusterRequest
  ): zio.aws.memorydb.model.UpdateClusterRequest.ReadOnly = new Wrapper(impl)
}
