package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ParameterGroup(
    name: Option[String] = None,
    family: Option[String] = None,
    description: Option[String] = None,
    arn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ParameterGroup = {
    import ParameterGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ParameterGroup
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(family.map(value => value: java.lang.String))(_.family)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.ParameterGroup.ReadOnly =
    zio.aws.memorydb.model.ParameterGroup.wrap(buildAwsValue())
}
object ParameterGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ParameterGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.ParameterGroup =
      zio.aws.memorydb.model.ParameterGroup(
        name.map(value => value),
        family.map(value => value),
        description.map(value => value),
        arn.map(value => value)
      )
    def name: Option[String]
    def family: Option[String]
    def description: Option[String]
    def arn: Option[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("family", family)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ParameterGroup
  ) extends zio.aws.memorydb.model.ParameterGroup.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val family: Option[String] =
      scala.Option(impl.family()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ParameterGroup
  ): zio.aws.memorydb.model.ParameterGroup.ReadOnly = new Wrapper(impl)
}
