package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.memorydb.model.primitives.UserName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateAclRequest(
    aclName: String,
    userNames: Option[Iterable[UserName]] = None,
    tags: Option[Iterable[zio.aws.memorydb.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.CreateAclRequest = {
    import CreateAclRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.CreateAclRequest
      .builder()
      .aclName(aclName: java.lang.String)
      .optionallyWith(
        userNames.map(value =>
          value.map { item =>
            UserName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userNames)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.CreateAclRequest.ReadOnly =
    zio.aws.memorydb.model.CreateAclRequest.wrap(buildAwsValue())
}
object CreateAclRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.CreateAclRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.CreateAclRequest =
      zio.aws.memorydb.model.CreateAclRequest(
        aclName,
        userNames.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def aclName: String
    def userNames: Option[List[UserName]]
    def tags: Option[List[zio.aws.memorydb.model.Tag.ReadOnly]]
    def getAclName: ZIO[Any, Nothing, String] = ZIO.succeed(aclName)
    def getUserNames: ZIO[Any, AwsError, List[UserName]] =
      AwsError.unwrapOptionField("userNames", userNames)
    def getTags: ZIO[Any, AwsError, List[zio.aws.memorydb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.CreateAclRequest
  ) extends zio.aws.memorydb.model.CreateAclRequest.ReadOnly {
    override val aclName: String = impl.aclName(): String
    override val userNames: Option[List[UserName]] = scala
      .Option(impl.userNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.memorydb.model.primitives.UserName(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.memorydb.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.memorydb.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.CreateAclRequest
  ): zio.aws.memorydb.model.CreateAclRequest.ReadOnly = new Wrapper(impl)
}
