package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.memorydb.model.primitives.{KmsKeyId, TargetBucket}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CopySnapshotRequest(
    sourceSnapshotName: String,
    targetSnapshotName: String,
    targetBucket: Option[TargetBucket] = None,
    kmsKeyId: Option[KmsKeyId] = None,
    tags: Option[Iterable[zio.aws.memorydb.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.CopySnapshotRequest = {
    import CopySnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.CopySnapshotRequest
      .builder()
      .sourceSnapshotName(sourceSnapshotName: java.lang.String)
      .targetSnapshotName(targetSnapshotName: java.lang.String)
      .optionallyWith(
        targetBucket.map(value => TargetBucket.unwrap(value): java.lang.String)
      )(_.targetBucket)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.CopySnapshotRequest.ReadOnly =
    zio.aws.memorydb.model.CopySnapshotRequest.wrap(buildAwsValue())
}
object CopySnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.CopySnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.CopySnapshotRequest =
      zio.aws.memorydb.model.CopySnapshotRequest(
        sourceSnapshotName,
        targetSnapshotName,
        targetBucket.map(value => value),
        kmsKeyId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sourceSnapshotName: String
    def targetSnapshotName: String
    def targetBucket: Option[TargetBucket]
    def kmsKeyId: Option[KmsKeyId]
    def tags: Option[List[zio.aws.memorydb.model.Tag.ReadOnly]]
    def getSourceSnapshotName: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceSnapshotName)
    def getTargetSnapshotName: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetSnapshotName)
    def getTargetBucket: ZIO[Any, AwsError, TargetBucket] =
      AwsError.unwrapOptionField("targetBucket", targetBucket)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.memorydb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.CopySnapshotRequest
  ) extends zio.aws.memorydb.model.CopySnapshotRequest.ReadOnly {
    override val sourceSnapshotName: String = impl.sourceSnapshotName(): String
    override val targetSnapshotName: String = impl.targetSnapshotName(): String
    override val targetBucket: Option[TargetBucket] = scala
      .Option(impl.targetBucket())
      .map(value => zio.aws.memorydb.model.primitives.TargetBucket(value))
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.memorydb.model.primitives.KmsKeyId(value))
    override val tags: Option[List[zio.aws.memorydb.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.memorydb.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.CopySnapshotRequest
  ): zio.aws.memorydb.model.CopySnapshotRequest.ReadOnly = new Wrapper(impl)
}
