package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SlotMigration(progressPercentage: Option[Double] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.SlotMigration = {
    import SlotMigration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.SlotMigration
      .builder()
      .optionallyWith(progressPercentage.map(value => value: java.lang.Double))(
        _.progressPercentage
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.SlotMigration.ReadOnly =
    zio.aws.memorydb.model.SlotMigration.wrap(buildAwsValue())
}
object SlotMigration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.SlotMigration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.SlotMigration =
      zio.aws.memorydb.model
        .SlotMigration(progressPercentage.map(value => value))
    def progressPercentage: Option[Double]
    def getProgressPercentage: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("progressPercentage", progressPercentage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.SlotMigration
  ) extends zio.aws.memorydb.model.SlotMigration.ReadOnly {
    override val progressPercentage: Option[Double] =
      scala.Option(impl.progressPercentage()).map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.SlotMigration
  ): zio.aws.memorydb.model.SlotMigration.ReadOnly = new Wrapper(impl)
}
