package zio.aws.memorydb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.memorydb.model.primitives.{BooleanOptional, IntegerOptional}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeSnapshotsRequest(
    clusterName: Option[String] = None,
    snapshotName: Option[String] = None,
    source: Option[String] = None,
    nextToken: Option[String] = None,
    maxResults: Option[IntegerOptional] = None,
    showDetail: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsRequest = {
    import DescribeSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsRequest
      .builder()
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(snapshotName.map(value => value: java.lang.String))(
        _.snapshotName
      )
      .optionallyWith(source.map(value => value: java.lang.String))(_.source)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(showDetail.map(value => value: java.lang.Boolean))(
        _.showDetail
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.DescribeSnapshotsRequest.ReadOnly =
    zio.aws.memorydb.model.DescribeSnapshotsRequest.wrap(buildAwsValue())
}
object DescribeSnapshotsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DescribeSnapshotsRequest =
      zio.aws.memorydb.model.DescribeSnapshotsRequest(
        clusterName.map(value => value),
        snapshotName.map(value => value),
        source.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        showDetail.map(value => value)
      )
    def clusterName: Option[String]
    def snapshotName: Option[String]
    def source: Option[String]
    def nextToken: Option[String]
    def maxResults: Option[IntegerOptional]
    def showDetail: Option[BooleanOptional]
    def getClusterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getSnapshotName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotName", snapshotName)
    def getSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("source", source)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getShowDetail: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("showDetail", showDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsRequest
  ) extends zio.aws.memorydb.model.DescribeSnapshotsRequest.ReadOnly {
    override val clusterName: Option[String] =
      scala.Option(impl.clusterName()).map(value => value: String)
    override val snapshotName: Option[String] =
      scala.Option(impl.snapshotName()).map(value => value: String)
    override val source: Option[String] =
      scala.Option(impl.source()).map(value => value: String)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[IntegerOptional] =
      scala.Option(impl.maxResults()).map(value => value: IntegerOptional)
    override val showDetail: Option[BooleanOptional] =
      scala.Option(impl.showDetail()).map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsRequest
  ): zio.aws.memorydb.model.DescribeSnapshotsRequest.ReadOnly = new Wrapper(
    impl
  )
}
