package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.memorydb.model.primitives.TStamp
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ShardDetail(
    name: Option[String] = None,
    configuration: Option[zio.aws.memorydb.model.ShardConfiguration] = None,
    size: Option[String] = None,
    snapshotCreationTime: Option[TStamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ShardDetail = {
    import ShardDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ShardDetail
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(size.map(value => value: java.lang.String))(_.size)
      .optionallyWith(
        snapshotCreationTime.map(value => TStamp.unwrap(value): Instant)
      )(_.snapshotCreationTime)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.ShardDetail.ReadOnly =
    zio.aws.memorydb.model.ShardDetail.wrap(buildAwsValue())
}
object ShardDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ShardDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.ShardDetail =
      zio.aws.memorydb.model.ShardDetail(
        name.map(value => value),
        configuration.map(value => value.asEditable),
        size.map(value => value),
        snapshotCreationTime.map(value => value)
      )
    def name: Option[String]
    def configuration
        : Option[zio.aws.memorydb.model.ShardConfiguration.ReadOnly]
    def size: Option[String]
    def snapshotCreationTime: Option[TStamp]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.memorydb.model.ShardConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getSize: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("size", size)
    def getSnapshotCreationTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("snapshotCreationTime", snapshotCreationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ShardDetail
  ) extends zio.aws.memorydb.model.ShardDetail.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val configuration
        : Option[zio.aws.memorydb.model.ShardConfiguration.ReadOnly] = scala
      .Option(impl.configuration())
      .map(value => zio.aws.memorydb.model.ShardConfiguration.wrap(value))
    override val size: Option[String] =
      scala.Option(impl.size()).map(value => value: String)
    override val snapshotCreationTime: Option[TStamp] = scala
      .Option(impl.snapshotCreationTime())
      .map(value => zio.aws.memorydb.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ShardDetail
  ): zio.aws.memorydb.model.ShardDetail.ReadOnly = new Wrapper(impl)
}
