package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ServiceUpdateRequest(
    serviceUpdateNameToApply: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ServiceUpdateRequest = {
    import ServiceUpdateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ServiceUpdateRequest
      .builder()
      .optionallyWith(
        serviceUpdateNameToApply.map(value => value: java.lang.String)
      )(_.serviceUpdateNameToApply)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.ServiceUpdateRequest.ReadOnly =
    zio.aws.memorydb.model.ServiceUpdateRequest.wrap(buildAwsValue())
}
object ServiceUpdateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ServiceUpdateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.ServiceUpdateRequest =
      zio.aws.memorydb.model
        .ServiceUpdateRequest(serviceUpdateNameToApply.map(value => value))
    def serviceUpdateNameToApply: Option[String]
    def getServiceUpdateNameToApply: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("serviceUpdateNameToApply", serviceUpdateNameToApply)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ServiceUpdateRequest
  ) extends zio.aws.memorydb.model.ServiceUpdateRequest.ReadOnly {
    override val serviceUpdateNameToApply: Option[String] =
      scala.Option(impl.serviceUpdateNameToApply()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ServiceUpdateRequest
  ): zio.aws.memorydb.model.ServiceUpdateRequest.ReadOnly = new Wrapper(impl)
}
