package zio.aws.memorydb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.memorydb.model.primitives.IntegerOptional
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeEngineVersionsRequest(
    engineVersion: Option[String] = None,
    parameterGroupFamily: Option[String] = None,
    maxResults: Option[IntegerOptional] = None,
    nextToken: Option[String] = None,
    defaultOnly: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsRequest = {
    import DescribeEngineVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsRequest
      .builder()
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        parameterGroupFamily.map(value => value: java.lang.String)
      )(_.parameterGroupFamily)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(defaultOnly.map(value => value: java.lang.Boolean))(
        _.defaultOnly
      )
      .build()
  }
  def asReadOnly
      : zio.aws.memorydb.model.DescribeEngineVersionsRequest.ReadOnly =
    zio.aws.memorydb.model.DescribeEngineVersionsRequest.wrap(buildAwsValue())
}
object DescribeEngineVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DescribeEngineVersionsRequest =
      zio.aws.memorydb.model.DescribeEngineVersionsRequest(
        engineVersion.map(value => value),
        parameterGroupFamily.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        defaultOnly.map(value => value)
      )
    def engineVersion: Option[String]
    def parameterGroupFamily: Option[String]
    def maxResults: Option[IntegerOptional]
    def nextToken: Option[String]
    def defaultOnly: Option[Boolean]
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getParameterGroupFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupFamily", parameterGroupFamily)
    def getMaxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getDefaultOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("defaultOnly", defaultOnly)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsRequest
  ) extends zio.aws.memorydb.model.DescribeEngineVersionsRequest.ReadOnly {
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val parameterGroupFamily: Option[String] =
      scala.Option(impl.parameterGroupFamily()).map(value => value: String)
    override val maxResults: Option[IntegerOptional] =
      scala.Option(impl.maxResults()).map(value => value: IntegerOptional)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val defaultOnly: Option[Boolean] =
      scala.Option(impl.defaultOnly()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsRequest
  ): zio.aws.memorydb.model.DescribeEngineVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
