package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.memorydb.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ReplicaConfigurationRequest(
    replicaCount: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ReplicaConfigurationRequest = {
    import ReplicaConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ReplicaConfigurationRequest
      .builder()
      .optionallyWith(replicaCount.map(value => value: java.lang.Integer))(
        _.replicaCount
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.ReplicaConfigurationRequest.ReadOnly =
    zio.aws.memorydb.model.ReplicaConfigurationRequest.wrap(buildAwsValue())
}
object ReplicaConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ReplicaConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.ReplicaConfigurationRequest =
      zio.aws.memorydb.model
        .ReplicaConfigurationRequest(replicaCount.map(value => value))
    def replicaCount: Option[Integer]
    def getReplicaCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("replicaCount", replicaCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ReplicaConfigurationRequest
  ) extends zio.aws.memorydb.model.ReplicaConfigurationRequest.ReadOnly {
    override val replicaCount: Option[Integer] =
      scala.Option(impl.replicaCount()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ReplicaConfigurationRequest
  ): zio.aws.memorydb.model.ReplicaConfigurationRequest.ReadOnly = new Wrapper(
    impl
  )
}
