package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.memorydb.model.primitives.UserName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateAclRequest(
    aclName: String,
    userNamesToAdd: Option[Iterable[UserName]] = None,
    userNamesToRemove: Option[Iterable[UserName]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.UpdateAclRequest = {
    import UpdateAclRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.UpdateAclRequest
      .builder()
      .aclName(aclName: java.lang.String)
      .optionallyWith(
        userNamesToAdd.map(value =>
          value.map { item =>
            UserName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userNamesToAdd)
      .optionallyWith(
        userNamesToRemove.map(value =>
          value.map { item =>
            UserName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userNamesToRemove)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.UpdateAclRequest.ReadOnly =
    zio.aws.memorydb.model.UpdateAclRequest.wrap(buildAwsValue())
}
object UpdateAclRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.UpdateAclRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.UpdateAclRequest =
      zio.aws.memorydb.model.UpdateAclRequest(
        aclName,
        userNamesToAdd.map(value => value),
        userNamesToRemove.map(value => value)
      )
    def aclName: String
    def userNamesToAdd: Option[List[UserName]]
    def userNamesToRemove: Option[List[UserName]]
    def getAclName: ZIO[Any, Nothing, String] = ZIO.succeed(aclName)
    def getUserNamesToAdd: ZIO[Any, AwsError, List[UserName]] =
      AwsError.unwrapOptionField("userNamesToAdd", userNamesToAdd)
    def getUserNamesToRemove: ZIO[Any, AwsError, List[UserName]] =
      AwsError.unwrapOptionField("userNamesToRemove", userNamesToRemove)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateAclRequest
  ) extends zio.aws.memorydb.model.UpdateAclRequest.ReadOnly {
    override val aclName: String = impl.aclName(): String
    override val userNamesToAdd: Option[List[UserName]] = scala
      .Option(impl.userNamesToAdd())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.memorydb.model.primitives.UserName(item)
        }.toList
      )
    override val userNamesToRemove: Option[List[UserName]] = scala
      .Option(impl.userNamesToRemove())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.memorydb.model.primitives.UserName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateAclRequest
  ): zio.aws.memorydb.model.UpdateAclRequest.ReadOnly = new Wrapper(impl)
}
