package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.memorydb.model.primitives.{AccessString, UserName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateUserRequest(
    userName: UserName,
    authenticationMode: zio.aws.memorydb.model.AuthenticationMode,
    accessString: AccessString,
    tags: Option[Iterable[zio.aws.memorydb.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.CreateUserRequest = {
    import CreateUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.CreateUserRequest
      .builder()
      .userName(UserName.unwrap(userName): java.lang.String)
      .authenticationMode(authenticationMode.buildAwsValue())
      .accessString(AccessString.unwrap(accessString): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.CreateUserRequest.ReadOnly =
    zio.aws.memorydb.model.CreateUserRequest.wrap(buildAwsValue())
}
object CreateUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.CreateUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.CreateUserRequest =
      zio.aws.memorydb.model.CreateUserRequest(
        userName,
        authenticationMode.asEditable,
        accessString,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def userName: UserName
    def authenticationMode: zio.aws.memorydb.model.AuthenticationMode.ReadOnly
    def accessString: AccessString
    def tags: Option[List[zio.aws.memorydb.model.Tag.ReadOnly]]
    def getUserName: ZIO[Any, Nothing, UserName] = ZIO.succeed(userName)
    def getAuthenticationMode: ZIO[
      Any,
      Nothing,
      zio.aws.memorydb.model.AuthenticationMode.ReadOnly
    ] = ZIO.succeed(authenticationMode)
    def getAccessString: ZIO[Any, Nothing, AccessString] =
      ZIO.succeed(accessString)
    def getTags: ZIO[Any, AwsError, List[zio.aws.memorydb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.CreateUserRequest
  ) extends zio.aws.memorydb.model.CreateUserRequest.ReadOnly {
    override val userName: UserName =
      zio.aws.memorydb.model.primitives.UserName(impl.userName())
    override val authenticationMode
        : zio.aws.memorydb.model.AuthenticationMode.ReadOnly =
      zio.aws.memorydb.model.AuthenticationMode.wrap(impl.authenticationMode())
    override val accessString: AccessString =
      zio.aws.memorydb.model.primitives.AccessString(impl.accessString())
    override val tags: Option[List[zio.aws.memorydb.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.memorydb.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.CreateUserRequest
  ): zio.aws.memorydb.model.CreateUserRequest.ReadOnly = new Wrapper(impl)
}
