package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Snapshot(
    name: Option[String] = None,
    status: Option[String] = None,
    source: Option[String] = None,
    kmsKeyId: Option[String] = None,
    arn: Option[String] = None,
    clusterConfiguration: Option[zio.aws.memorydb.model.ClusterConfiguration] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.Snapshot = {
    import Snapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.Snapshot
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(source.map(value => value: java.lang.String))(_.source)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(clusterConfiguration.map(value => value.buildAwsValue()))(
        _.clusterConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.Snapshot.ReadOnly =
    zio.aws.memorydb.model.Snapshot.wrap(buildAwsValue())
}
object Snapshot {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.memorydb.model.Snapshot] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.Snapshot =
      zio.aws.memorydb.model.Snapshot(
        name.map(value => value),
        status.map(value => value),
        source.map(value => value),
        kmsKeyId.map(value => value),
        arn.map(value => value),
        clusterConfiguration.map(value => value.asEditable)
      )
    def name: Option[String]
    def status: Option[String]
    def source: Option[String]
    def kmsKeyId: Option[String]
    def arn: Option[String]
    def clusterConfiguration
        : Option[zio.aws.memorydb.model.ClusterConfiguration.ReadOnly]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("source", source)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getClusterConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.memorydb.model.ClusterConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("clusterConfiguration", clusterConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.Snapshot
  ) extends zio.aws.memorydb.model.Snapshot.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val source: Option[String] =
      scala.Option(impl.source()).map(value => value: String)
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
    override val clusterConfiguration
        : Option[zio.aws.memorydb.model.ClusterConfiguration.ReadOnly] = scala
      .Option(impl.clusterConfiguration())
      .map(value => zio.aws.memorydb.model.ClusterConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.Snapshot
  ): zio.aws.memorydb.model.Snapshot.ReadOnly = new Wrapper(impl)
}
