package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EngineVersionInfo(
    engineVersion: Option[String] = None,
    enginePatchVersion: Option[String] = None,
    parameterGroupFamily: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.EngineVersionInfo = {
    import EngineVersionInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.EngineVersionInfo
      .builder()
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(enginePatchVersion.map(value => value: java.lang.String))(
        _.enginePatchVersion
      )
      .optionallyWith(
        parameterGroupFamily.map(value => value: java.lang.String)
      )(_.parameterGroupFamily)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.EngineVersionInfo.ReadOnly =
    zio.aws.memorydb.model.EngineVersionInfo.wrap(buildAwsValue())
}
object EngineVersionInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.EngineVersionInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.EngineVersionInfo =
      zio.aws.memorydb.model.EngineVersionInfo(
        engineVersion.map(value => value),
        enginePatchVersion.map(value => value),
        parameterGroupFamily.map(value => value)
      )
    def engineVersion: Option[String]
    def enginePatchVersion: Option[String]
    def parameterGroupFamily: Option[String]
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getEnginePatchVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("enginePatchVersion", enginePatchVersion)
    def getParameterGroupFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupFamily", parameterGroupFamily)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.EngineVersionInfo
  ) extends zio.aws.memorydb.model.EngineVersionInfo.ReadOnly {
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val enginePatchVersion: Option[String] =
      scala.Option(impl.enginePatchVersion()).map(value => value: String)
    override val parameterGroupFamily: Option[String] =
      scala.Option(impl.parameterGroupFamily()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.EngineVersionInfo
  ): zio.aws.memorydb.model.EngineVersionInfo.ReadOnly = new Wrapper(impl)
}
