package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ClusterPendingUpdates(
    resharding: Option[zio.aws.memorydb.model.ReshardingStatus] = None,
    acLs: Option[zio.aws.memorydb.model.ACLsUpdateStatus] = None,
    serviceUpdates: Option[
      Iterable[zio.aws.memorydb.model.PendingModifiedServiceUpdate]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ClusterPendingUpdates = {
    import ClusterPendingUpdates.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ClusterPendingUpdates
      .builder()
      .optionallyWith(resharding.map(value => value.buildAwsValue()))(
        _.resharding
      )
      .optionallyWith(acLs.map(value => value.buildAwsValue()))(_.acLs)
      .optionallyWith(
        serviceUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceUpdates)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.ClusterPendingUpdates.ReadOnly =
    zio.aws.memorydb.model.ClusterPendingUpdates.wrap(buildAwsValue())
}
object ClusterPendingUpdates {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ClusterPendingUpdates
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.ClusterPendingUpdates =
      zio.aws.memorydb.model.ClusterPendingUpdates(
        resharding.map(value => value.asEditable),
        acLs.map(value => value.asEditable),
        serviceUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resharding: Option[zio.aws.memorydb.model.ReshardingStatus.ReadOnly]
    def acLs: Option[zio.aws.memorydb.model.ACLsUpdateStatus.ReadOnly]
    def serviceUpdates: Option[
      List[zio.aws.memorydb.model.PendingModifiedServiceUpdate.ReadOnly]
    ]
    def getResharding
        : ZIO[Any, AwsError, zio.aws.memorydb.model.ReshardingStatus.ReadOnly] =
      AwsError.unwrapOptionField("resharding", resharding)
    def getAcLs
        : ZIO[Any, AwsError, zio.aws.memorydb.model.ACLsUpdateStatus.ReadOnly] =
      AwsError.unwrapOptionField("acLs", acLs)
    def getServiceUpdates: ZIO[Any, AwsError, List[
      zio.aws.memorydb.model.PendingModifiedServiceUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField("serviceUpdates", serviceUpdates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ClusterPendingUpdates
  ) extends zio.aws.memorydb.model.ClusterPendingUpdates.ReadOnly {
    override val resharding
        : Option[zio.aws.memorydb.model.ReshardingStatus.ReadOnly] = scala
      .Option(impl.resharding())
      .map(value => zio.aws.memorydb.model.ReshardingStatus.wrap(value))
    override val acLs
        : Option[zio.aws.memorydb.model.ACLsUpdateStatus.ReadOnly] = scala
      .Option(impl.acLs())
      .map(value => zio.aws.memorydb.model.ACLsUpdateStatus.wrap(value))
    override val serviceUpdates: Option[
      List[zio.aws.memorydb.model.PendingModifiedServiceUpdate.ReadOnly]
    ] = scala
      .Option(impl.serviceUpdates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.memorydb.model.PendingModifiedServiceUpdate.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ClusterPendingUpdates
  ): zio.aws.memorydb.model.ClusterPendingUpdates.ReadOnly = new Wrapper(impl)
}
