package zio.aws.memorydb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.memorydb.model.primitives.IntegerOptional
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Authentication(
    `type`: Option[zio.aws.memorydb.model.AuthenticationType] = None,
    passwordCount: Option[IntegerOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.Authentication = {
    import Authentication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.Authentication
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        passwordCount.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.passwordCount)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.Authentication.ReadOnly =
    zio.aws.memorydb.model.Authentication.wrap(buildAwsValue())
}
object Authentication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.Authentication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.Authentication =
      zio.aws.memorydb.model.Authentication(
        `type`.map(value => value),
        passwordCount.map(value => value)
      )
    def `type`: Option[zio.aws.memorydb.model.AuthenticationType]
    def passwordCount: Option[IntegerOptional]
    def getType: ZIO[Any, AwsError, zio.aws.memorydb.model.AuthenticationType] =
      AwsError.unwrapOptionField("type", `type`)
    def getPasswordCount: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("passwordCount", passwordCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.Authentication
  ) extends zio.aws.memorydb.model.Authentication.ReadOnly {
    override val `type`: Option[zio.aws.memorydb.model.AuthenticationType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.memorydb.model.AuthenticationType.wrap(value))
    override val passwordCount: Option[IntegerOptional] = scala
      .Option(impl.passwordCount())
      .map(value => zio.aws.memorydb.model.primitives.IntegerOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.Authentication
  ): zio.aws.memorydb.model.Authentication.ReadOnly = new Wrapper(impl)
}
