package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BatchUpdateClusterResponse(
    processedClusters: Option[Iterable[zio.aws.memorydb.model.Cluster]] = None,
    unprocessedClusters: Option[
      Iterable[zio.aws.memorydb.model.UnprocessedCluster]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterResponse = {
    import BatchUpdateClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterResponse
      .builder()
      .optionallyWith(
        processedClusters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processedClusters)
      .optionallyWith(
        unprocessedClusters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedClusters)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.BatchUpdateClusterResponse.ReadOnly =
    zio.aws.memorydb.model.BatchUpdateClusterResponse.wrap(buildAwsValue())
}
object BatchUpdateClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.BatchUpdateClusterResponse =
      zio.aws.memorydb.model.BatchUpdateClusterResponse(
        processedClusters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unprocessedClusters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def processedClusters: Option[List[zio.aws.memorydb.model.Cluster.ReadOnly]]
    def unprocessedClusters
        : Option[List[zio.aws.memorydb.model.UnprocessedCluster.ReadOnly]]
    def getProcessedClusters
        : ZIO[Any, AwsError, List[zio.aws.memorydb.model.Cluster.ReadOnly]] =
      AwsError.unwrapOptionField("processedClusters", processedClusters)
    def getUnprocessedClusters: ZIO[Any, AwsError, List[
      zio.aws.memorydb.model.UnprocessedCluster.ReadOnly
    ]] = AwsError.unwrapOptionField("unprocessedClusters", unprocessedClusters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterResponse
  ) extends zio.aws.memorydb.model.BatchUpdateClusterResponse.ReadOnly {
    override val processedClusters
        : Option[List[zio.aws.memorydb.model.Cluster.ReadOnly]] = scala
      .Option(impl.processedClusters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.memorydb.model.Cluster.wrap(item)
        }.toList
      )
    override val unprocessedClusters
        : Option[List[zio.aws.memorydb.model.UnprocessedCluster.ReadOnly]] =
      scala
        .Option(impl.unprocessedClusters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.memorydb.model.UnprocessedCluster.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterResponse
  ): zio.aws.memorydb.model.BatchUpdateClusterResponse.ReadOnly = new Wrapper(
    impl
  )
}
