package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateClusterResponse(
    cluster: Option[zio.aws.memorydb.model.Cluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.UpdateClusterResponse = {
    import UpdateClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.UpdateClusterResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.UpdateClusterResponse.ReadOnly =
    zio.aws.memorydb.model.UpdateClusterResponse.wrap(buildAwsValue())
}
object UpdateClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.UpdateClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.UpdateClusterResponse =
      zio.aws.memorydb.model
        .UpdateClusterResponse(cluster.map(value => value.asEditable))
    def cluster: Option[zio.aws.memorydb.model.Cluster.ReadOnly]
    def getCluster
        : ZIO[Any, AwsError, zio.aws.memorydb.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateClusterResponse
  ) extends zio.aws.memorydb.model.UpdateClusterResponse.ReadOnly {
    override val cluster: Option[zio.aws.memorydb.model.Cluster.ReadOnly] =
      scala
        .Option(impl.cluster())
        .map(value => zio.aws.memorydb.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateClusterResponse
  ): zio.aws.memorydb.model.UpdateClusterResponse.ReadOnly = new Wrapper(impl)
}
