package zio.aws.memorydb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.memorydb.model.primitives.{
  ACLName,
  BooleanOptional,
  IntegerOptional
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Cluster(
    name: Option[String] = None,
    description: Option[String] = None,
    status: Option[String] = None,
    pendingUpdates: Option[zio.aws.memorydb.model.ClusterPendingUpdates] = None,
    numberOfShards: Option[IntegerOptional] = None,
    shards: Option[Iterable[zio.aws.memorydb.model.Shard]] = None,
    availabilityMode: Option[zio.aws.memorydb.model.AZStatus] = None,
    clusterEndpoint: Option[zio.aws.memorydb.model.Endpoint] = None,
    nodeType: Option[String] = None,
    engineVersion: Option[String] = None,
    enginePatchVersion: Option[String] = None,
    parameterGroupName: Option[String] = None,
    parameterGroupStatus: Option[String] = None,
    securityGroups: Option[
      Iterable[zio.aws.memorydb.model.SecurityGroupMembership]
    ] = None,
    subnetGroupName: Option[String] = None,
    tlsEnabled: Option[BooleanOptional] = None,
    kmsKeyId: Option[String] = None,
    arn: Option[String] = None,
    snsTopicArn: Option[String] = None,
    snsTopicStatus: Option[String] = None,
    snapshotRetentionLimit: Option[IntegerOptional] = None,
    maintenanceWindow: Option[String] = None,
    snapshotWindow: Option[String] = None,
    aclName: Option[ACLName] = None,
    autoMinorVersionUpgrade: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.Cluster = {
    import Cluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.Cluster
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(pendingUpdates.map(value => value.buildAwsValue()))(
        _.pendingUpdates
      )
      .optionallyWith(
        numberOfShards.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.numberOfShards)
      .optionallyWith(
        shards.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.shards)
      .optionallyWith(availabilityMode.map(value => value.unwrap))(
        _.availabilityMode
      )
      .optionallyWith(clusterEndpoint.map(value => value.buildAwsValue()))(
        _.clusterEndpoint
      )
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(enginePatchVersion.map(value => value: java.lang.String))(
        _.enginePatchVersion
      )
      .optionallyWith(parameterGroupName.map(value => value: java.lang.String))(
        _.parameterGroupName
      )
      .optionallyWith(
        parameterGroupStatus.map(value => value: java.lang.String)
      )(_.parameterGroupStatus)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(subnetGroupName.map(value => value: java.lang.String))(
        _.subnetGroupName
      )
      .optionallyWith(
        tlsEnabled.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.tlsEnabled)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(snsTopicArn.map(value => value: java.lang.String))(
        _.snsTopicArn
      )
      .optionallyWith(snsTopicStatus.map(value => value: java.lang.String))(
        _.snsTopicStatus
      )
      .optionallyWith(
        snapshotRetentionLimit.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.snapshotRetentionLimit)
      .optionallyWith(maintenanceWindow.map(value => value: java.lang.String))(
        _.maintenanceWindow
      )
      .optionallyWith(snapshotWindow.map(value => value: java.lang.String))(
        _.snapshotWindow
      )
      .optionallyWith(
        aclName.map(value => ACLName.unwrap(value): java.lang.String)
      )(_.aclName)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.autoMinorVersionUpgrade)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.Cluster.ReadOnly =
    zio.aws.memorydb.model.Cluster.wrap(buildAwsValue())
}
object Cluster {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.memorydb.model.Cluster] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.Cluster =
      zio.aws.memorydb.model.Cluster(
        name.map(value => value),
        description.map(value => value),
        status.map(value => value),
        pendingUpdates.map(value => value.asEditable),
        numberOfShards.map(value => value),
        shards.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        availabilityMode.map(value => value),
        clusterEndpoint.map(value => value.asEditable),
        nodeType.map(value => value),
        engineVersion.map(value => value),
        enginePatchVersion.map(value => value),
        parameterGroupName.map(value => value),
        parameterGroupStatus.map(value => value),
        securityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        subnetGroupName.map(value => value),
        tlsEnabled.map(value => value),
        kmsKeyId.map(value => value),
        arn.map(value => value),
        snsTopicArn.map(value => value),
        snsTopicStatus.map(value => value),
        snapshotRetentionLimit.map(value => value),
        maintenanceWindow.map(value => value),
        snapshotWindow.map(value => value),
        aclName.map(value => value),
        autoMinorVersionUpgrade.map(value => value)
      )
    def name: Option[String]
    def description: Option[String]
    def status: Option[String]
    def pendingUpdates
        : Option[zio.aws.memorydb.model.ClusterPendingUpdates.ReadOnly]
    def numberOfShards: Option[IntegerOptional]
    def shards: Option[List[zio.aws.memorydb.model.Shard.ReadOnly]]
    def availabilityMode: Option[zio.aws.memorydb.model.AZStatus]
    def clusterEndpoint: Option[zio.aws.memorydb.model.Endpoint.ReadOnly]
    def nodeType: Option[String]
    def engineVersion: Option[String]
    def enginePatchVersion: Option[String]
    def parameterGroupName: Option[String]
    def parameterGroupStatus: Option[String]
    def securityGroups
        : Option[List[zio.aws.memorydb.model.SecurityGroupMembership.ReadOnly]]
    def subnetGroupName: Option[String]
    def tlsEnabled: Option[BooleanOptional]
    def kmsKeyId: Option[String]
    def arn: Option[String]
    def snsTopicArn: Option[String]
    def snsTopicStatus: Option[String]
    def snapshotRetentionLimit: Option[IntegerOptional]
    def maintenanceWindow: Option[String]
    def snapshotWindow: Option[String]
    def aclName: Option[ACLName]
    def autoMinorVersionUpgrade: Option[BooleanOptional]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getPendingUpdates: ZIO[
      Any,
      AwsError,
      zio.aws.memorydb.model.ClusterPendingUpdates.ReadOnly
    ] = AwsError.unwrapOptionField("pendingUpdates", pendingUpdates)
    def getNumberOfShards: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numberOfShards", numberOfShards)
    def getShards
        : ZIO[Any, AwsError, List[zio.aws.memorydb.model.Shard.ReadOnly]] =
      AwsError.unwrapOptionField("shards", shards)
    def getAvailabilityMode
        : ZIO[Any, AwsError, zio.aws.memorydb.model.AZStatus] =
      AwsError.unwrapOptionField("availabilityMode", availabilityMode)
    def getClusterEndpoint
        : ZIO[Any, AwsError, zio.aws.memorydb.model.Endpoint.ReadOnly] =
      AwsError.unwrapOptionField("clusterEndpoint", clusterEndpoint)
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getEnginePatchVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("enginePatchVersion", enginePatchVersion)
    def getParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupName)
    def getParameterGroupStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupStatus", parameterGroupStatus)
    def getSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.memorydb.model.SecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetGroupName", subnetGroupName)
    def getTlsEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("tlsEnabled", tlsEnabled)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getSnsTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getSnsTopicStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopicStatus", snsTopicStatus)
    def getSnapshotRetentionLimit: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "snapshotRetentionLimit",
        snapshotRetentionLimit
      )
    def getMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceWindow", maintenanceWindow)
    def getSnapshotWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotWindow", snapshotWindow)
    def getAclName: ZIO[Any, AwsError, ACLName] =
      AwsError.unwrapOptionField("aclName", aclName)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.Cluster
  ) extends zio.aws.memorydb.model.Cluster.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val pendingUpdates
        : Option[zio.aws.memorydb.model.ClusterPendingUpdates.ReadOnly] = scala
      .Option(impl.pendingUpdates())
      .map(value => zio.aws.memorydb.model.ClusterPendingUpdates.wrap(value))
    override val numberOfShards: Option[IntegerOptional] = scala
      .Option(impl.numberOfShards())
      .map(value => zio.aws.memorydb.model.primitives.IntegerOptional(value))
    override val shards: Option[List[zio.aws.memorydb.model.Shard.ReadOnly]] =
      scala
        .Option(impl.shards())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.memorydb.model.Shard.wrap(item)
          }.toList
        )
    override val availabilityMode: Option[zio.aws.memorydb.model.AZStatus] =
      scala
        .Option(impl.availabilityMode())
        .map(value => zio.aws.memorydb.model.AZStatus.wrap(value))
    override val clusterEndpoint
        : Option[zio.aws.memorydb.model.Endpoint.ReadOnly] = scala
      .Option(impl.clusterEndpoint())
      .map(value => zio.aws.memorydb.model.Endpoint.wrap(value))
    override val nodeType: Option[String] =
      scala.Option(impl.nodeType()).map(value => value: String)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val enginePatchVersion: Option[String] =
      scala.Option(impl.enginePatchVersion()).map(value => value: String)
    override val parameterGroupName: Option[String] =
      scala.Option(impl.parameterGroupName()).map(value => value: String)
    override val parameterGroupStatus: Option[String] =
      scala.Option(impl.parameterGroupStatus()).map(value => value: String)
    override val securityGroups: Option[
      List[zio.aws.memorydb.model.SecurityGroupMembership.ReadOnly]
    ] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.memorydb.model.SecurityGroupMembership.wrap(item)
        }.toList
      )
    override val subnetGroupName: Option[String] =
      scala.Option(impl.subnetGroupName()).map(value => value: String)
    override val tlsEnabled: Option[BooleanOptional] = scala
      .Option(impl.tlsEnabled())
      .map(value => zio.aws.memorydb.model.primitives.BooleanOptional(value))
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
    override val snsTopicArn: Option[String] =
      scala.Option(impl.snsTopicArn()).map(value => value: String)
    override val snsTopicStatus: Option[String] =
      scala.Option(impl.snsTopicStatus()).map(value => value: String)
    override val snapshotRetentionLimit: Option[IntegerOptional] = scala
      .Option(impl.snapshotRetentionLimit())
      .map(value => zio.aws.memorydb.model.primitives.IntegerOptional(value))
    override val maintenanceWindow: Option[String] =
      scala.Option(impl.maintenanceWindow()).map(value => value: String)
    override val snapshotWindow: Option[String] =
      scala.Option(impl.snapshotWindow()).map(value => value: String)
    override val aclName: Option[ACLName] = scala
      .Option(impl.aclName())
      .map(value => zio.aws.memorydb.model.primitives.ACLName(value))
    override val autoMinorVersionUpgrade: Option[BooleanOptional] = scala
      .Option(impl.autoMinorVersionUpgrade())
      .map(value => zio.aws.memorydb.model.primitives.BooleanOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.Cluster
  ): zio.aws.memorydb.model.Cluster.ReadOnly = new Wrapper(impl)
}
