package zio.aws.memorydb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.memorydb.model.primitives.{BooleanOptional, IntegerOptional}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeClustersRequest(
    clusterName: Option[String] = None,
    maxResults: Option[IntegerOptional] = None,
    nextToken: Option[String] = None,
    showShardDetails: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeClustersRequest = {
    import DescribeClustersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeClustersRequest
      .builder()
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(
        maxResults.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        showShardDetails.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.showShardDetails)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.DescribeClustersRequest.ReadOnly =
    zio.aws.memorydb.model.DescribeClustersRequest.wrap(buildAwsValue())
}
object DescribeClustersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeClustersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DescribeClustersRequest =
      zio.aws.memorydb.model.DescribeClustersRequest(
        clusterName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        showShardDetails.map(value => value)
      )
    def clusterName: Option[String]
    def maxResults: Option[IntegerOptional]
    def nextToken: Option[String]
    def showShardDetails: Option[BooleanOptional]
    def getClusterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getMaxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getShowShardDetails: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("showShardDetails", showShardDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeClustersRequest
  ) extends zio.aws.memorydb.model.DescribeClustersRequest.ReadOnly {
    override val clusterName: Option[String] =
      scala.Option(impl.clusterName()).map(value => value: String)
    override val maxResults: Option[IntegerOptional] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.memorydb.model.primitives.IntegerOptional(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val showShardDetails: Option[BooleanOptional] = scala
      .Option(impl.showShardDetails())
      .map(value => zio.aws.memorydb.model.primitives.BooleanOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeClustersRequest
  ): zio.aws.memorydb.model.DescribeClustersRequest.ReadOnly = new Wrapper(impl)
}
