package zio.aws.memorydb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.memorydb.model.primitives.IntegerOptional
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeServiceUpdatesRequest(
    serviceUpdateName: Option[String] = None,
    clusterNames: Option[Iterable[String]] = None,
    status: Option[Iterable[zio.aws.memorydb.model.ServiceUpdateStatus]] = None,
    maxResults: Option[IntegerOptional] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesRequest = {
    import DescribeServiceUpdatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesRequest
      .builder()
      .optionallyWith(serviceUpdateName.map(value => value: java.lang.String))(
        _.serviceUpdateName
      )
      .optionallyWith(
        clusterNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.clusterNames)
      .optionallyWith(
        status.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.statusWithStrings)
      .optionallyWith(
        maxResults.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.memorydb.model.DescribeServiceUpdatesRequest.ReadOnly =
    zio.aws.memorydb.model.DescribeServiceUpdatesRequest.wrap(buildAwsValue())
}
object DescribeServiceUpdatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DescribeServiceUpdatesRequest =
      zio.aws.memorydb.model.DescribeServiceUpdatesRequest(
        serviceUpdateName.map(value => value),
        clusterNames.map(value => value),
        status.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def serviceUpdateName: Option[String]
    def clusterNames: Option[List[String]]
    def status: Option[List[zio.aws.memorydb.model.ServiceUpdateStatus]]
    def maxResults: Option[IntegerOptional]
    def nextToken: Option[String]
    def getServiceUpdateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceUpdateName", serviceUpdateName)
    def getClusterNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("clusterNames", clusterNames)
    def getStatus
        : ZIO[Any, AwsError, List[zio.aws.memorydb.model.ServiceUpdateStatus]] =
      AwsError.unwrapOptionField("status", status)
    def getMaxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesRequest
  ) extends zio.aws.memorydb.model.DescribeServiceUpdatesRequest.ReadOnly {
    override val serviceUpdateName: Option[String] =
      scala.Option(impl.serviceUpdateName()).map(value => value: String)
    override val clusterNames: Option[List[String]] = scala
      .Option(impl.clusterNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val status
        : Option[List[zio.aws.memorydb.model.ServiceUpdateStatus]] = scala
      .Option(impl.status())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.memorydb.model.ServiceUpdateStatus.wrap(item)
        }.toList
      )
    override val maxResults: Option[IntegerOptional] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.memorydb.model.primitives.IntegerOptional(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesRequest
  ): zio.aws.memorydb.model.DescribeServiceUpdatesRequest.ReadOnly =
    new Wrapper(impl)
}
