package zio.aws.memorydb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.memorydb.model.primitives.IntegerOptional
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeParameterGroupsRequest(
    parameterGroupName: Option[String] = None,
    maxResults: Option[IntegerOptional] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsRequest = {
    import DescribeParameterGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsRequest
      .builder()
      .optionallyWith(parameterGroupName.map(value => value: java.lang.String))(
        _.parameterGroupName
      )
      .optionallyWith(
        maxResults.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.memorydb.model.DescribeParameterGroupsRequest.ReadOnly =
    zio.aws.memorydb.model.DescribeParameterGroupsRequest.wrap(buildAwsValue())
}
object DescribeParameterGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DescribeParameterGroupsRequest =
      zio.aws.memorydb.model.DescribeParameterGroupsRequest(
        parameterGroupName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def parameterGroupName: Option[String]
    def maxResults: Option[IntegerOptional]
    def nextToken: Option[String]
    def getParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupName)
    def getMaxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsRequest
  ) extends zio.aws.memorydb.model.DescribeParameterGroupsRequest.ReadOnly {
    override val parameterGroupName: Option[String] =
      scala.Option(impl.parameterGroupName()).map(value => value: String)
    override val maxResults: Option[IntegerOptional] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.memorydb.model.primitives.IntegerOptional(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsRequest
  ): zio.aws.memorydb.model.DescribeParameterGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
