package zio.aws.memorydb
import zio.aws.memorydb.model.ResetParameterGroupResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.memorydb.model.{
  UpdateAclResponse,
  DeleteUserRequest,
  DeleteSubnetGroupRequest,
  ParameterGroup,
  DescribeEventsResponse,
  UpdateClusterRequest,
  DescribeUsersRequest,
  DeleteParameterGroupResponse,
  DescribeSubnetGroupsRequest,
  DescribeAcLsRequest,
  DescribeSnapshotsRequest,
  Cluster,
  DescribeSnapshotsResponse,
  DeleteSnapshotRequest,
  CreateAclResponse,
  ResetParameterGroupRequest,
  DescribeSubnetGroupsResponse,
  DescribeParametersResponse,
  UpdateParameterGroupResponse,
  ListTagsRequest,
  UpdateSubnetGroupResponse,
  CreateSubnetGroupResponse,
  EngineVersionInfo,
  User,
  DescribeEngineVersionsRequest,
  DescribeEventsRequest,
  DeleteAclRequest,
  BatchUpdateClusterResponse,
  CopySnapshotRequest,
  UpdateParameterGroupRequest,
  CreateParameterGroupRequest,
  SubnetGroup,
  CreateClusterRequest,
  UpdateSubnetGroupRequest,
  Snapshot,
  UntagResourceResponse,
  CreateClusterResponse,
  CreateUserRequest,
  DescribeServiceUpdatesRequest,
  DeleteClusterRequest,
  CreateSubnetGroupRequest,
  CreateUserResponse,
  ListAllowedNodeTypeUpdatesRequest,
  ACL,
  CreateAclRequest,
  DescribeUsersResponse,
  DescribeServiceUpdatesResponse,
  BatchUpdateClusterRequest,
  FailoverShardResponse,
  CopySnapshotResponse,
  DescribeEngineVersionsResponse,
  DescribeClustersResponse,
  ListAllowedNodeTypeUpdatesResponse,
  DeleteAclResponse,
  UpdateAclRequest,
  ServiceUpdate,
  DeleteSubnetGroupResponse,
  UntagResourceRequest,
  DeleteUserResponse,
  CreateSnapshotRequest,
  UpdateUserRequest,
  Event,
  FailoverShardRequest,
  DeleteClusterResponse,
  DescribeAcLsResponse,
  DeleteParameterGroupRequest,
  UpdateUserResponse,
  TagResourceResponse,
  Parameter,
  DescribeParametersRequest,
  CreateParameterGroupResponse,
  CreateSnapshotResponse,
  DescribeParameterGroupsResponse,
  DescribeParameterGroupsRequest,
  DeleteSnapshotResponse,
  DescribeClustersRequest,
  ResetParameterGroupResponse,
  TagResourceRequest,
  ListTagsResponse,
  UpdateClusterResponse
}
import software.amazon.awssdk.services.memorydb.{
  MemoryDbAsyncClientBuilder,
  MemoryDbAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait MemoryDb extends AspectSupport[MemoryDb] {
  val api: MemoryDbAsyncClient
  def listAllowedNodeTypeUpdates(
      request: zio.aws.memorydb.model.ListAllowedNodeTypeUpdatesRequest
  ): IO[
    AwsError,
    zio.aws.memorydb.model.ListAllowedNodeTypeUpdatesResponse.ReadOnly
  ]
  def deleteACL(
      request: zio.aws.memorydb.model.DeleteAclRequest
  ): IO[AwsError, zio.aws.memorydb.model.DeleteAclResponse.ReadOnly]
  def describeClusters(
      request: zio.aws.memorydb.model.DescribeClustersRequest
  ): ZStream[Any, AwsError, zio.aws.memorydb.model.Cluster.ReadOnly]
  def describeClustersPaginated(
      request: zio.aws.memorydb.model.DescribeClustersRequest
  ): IO[AwsError, zio.aws.memorydb.model.DescribeClustersResponse.ReadOnly]
  def updateUser(
      request: zio.aws.memorydb.model.UpdateUserRequest
  ): IO[AwsError, zio.aws.memorydb.model.UpdateUserResponse.ReadOnly]
  def describeParameterGroups(
      request: zio.aws.memorydb.model.DescribeParameterGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.memorydb.model.ParameterGroup.ReadOnly]
  def describeParameterGroupsPaginated(
      request: zio.aws.memorydb.model.DescribeParameterGroupsRequest
  ): IO[
    AwsError,
    zio.aws.memorydb.model.DescribeParameterGroupsResponse.ReadOnly
  ]
  def batchUpdateCluster(
      request: zio.aws.memorydb.model.BatchUpdateClusterRequest
  ): IO[AwsError, zio.aws.memorydb.model.BatchUpdateClusterResponse.ReadOnly]
  def listTags(
      request: zio.aws.memorydb.model.ListTagsRequest
  ): IO[AwsError, zio.aws.memorydb.model.ListTagsResponse.ReadOnly]
  def describeParameters(
      request: zio.aws.memorydb.model.DescribeParametersRequest
  ): ZStream[Any, AwsError, zio.aws.memorydb.model.Parameter.ReadOnly]
  def describeParametersPaginated(
      request: zio.aws.memorydb.model.DescribeParametersRequest
  ): IO[AwsError, zio.aws.memorydb.model.DescribeParametersResponse.ReadOnly]
  def copySnapshot(
      request: zio.aws.memorydb.model.CopySnapshotRequest
  ): IO[AwsError, zio.aws.memorydb.model.CopySnapshotResponse.ReadOnly]
  def createCluster(
      request: zio.aws.memorydb.model.CreateClusterRequest
  ): IO[AwsError, zio.aws.memorydb.model.CreateClusterResponse.ReadOnly]
  def deleteCluster(
      request: zio.aws.memorydb.model.DeleteClusterRequest
  ): IO[AwsError, zio.aws.memorydb.model.DeleteClusterResponse.ReadOnly]
  def createACL(
      request: zio.aws.memorydb.model.CreateAclRequest
  ): IO[AwsError, zio.aws.memorydb.model.CreateAclResponse.ReadOnly]
  def createUser(
      request: zio.aws.memorydb.model.CreateUserRequest
  ): IO[AwsError, zio.aws.memorydb.model.CreateUserResponse.ReadOnly]
  def updateCluster(
      request: zio.aws.memorydb.model.UpdateClusterRequest
  ): IO[AwsError, zio.aws.memorydb.model.UpdateClusterResponse.ReadOnly]
  def deleteSnapshot(
      request: zio.aws.memorydb.model.DeleteSnapshotRequest
  ): IO[AwsError, zio.aws.memorydb.model.DeleteSnapshotResponse.ReadOnly]
  def updateParameterGroup(
      request: zio.aws.memorydb.model.UpdateParameterGroupRequest
  ): IO[AwsError, zio.aws.memorydb.model.UpdateParameterGroupResponse.ReadOnly]
  def describeServiceUpdates(
      request: zio.aws.memorydb.model.DescribeServiceUpdatesRequest
  ): ZStream[Any, AwsError, zio.aws.memorydb.model.ServiceUpdate.ReadOnly]
  def describeServiceUpdatesPaginated(
      request: zio.aws.memorydb.model.DescribeServiceUpdatesRequest
  ): IO[
    AwsError,
    zio.aws.memorydb.model.DescribeServiceUpdatesResponse.ReadOnly
  ]
  def describeUsers(
      request: zio.aws.memorydb.model.DescribeUsersRequest
  ): ZStream[Any, AwsError, zio.aws.memorydb.model.User.ReadOnly]
  def describeUsersPaginated(
      request: zio.aws.memorydb.model.DescribeUsersRequest
  ): IO[AwsError, zio.aws.memorydb.model.DescribeUsersResponse.ReadOnly]
  def untagResource(
      request: zio.aws.memorydb.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.memorydb.model.UntagResourceResponse.ReadOnly]
  def failoverShard(
      request: zio.aws.memorydb.model.FailoverShardRequest
  ): IO[AwsError, zio.aws.memorydb.model.FailoverShardResponse.ReadOnly]
  def updateACL(
      request: zio.aws.memorydb.model.UpdateAclRequest
  ): IO[AwsError, zio.aws.memorydb.model.UpdateAclResponse.ReadOnly]
  def describeEngineVersions(
      request: zio.aws.memorydb.model.DescribeEngineVersionsRequest
  ): ZStream[Any, AwsError, zio.aws.memorydb.model.EngineVersionInfo.ReadOnly]
  def describeEngineVersionsPaginated(
      request: zio.aws.memorydb.model.DescribeEngineVersionsRequest
  ): IO[
    AwsError,
    zio.aws.memorydb.model.DescribeEngineVersionsResponse.ReadOnly
  ]
  def deleteParameterGroup(
      request: zio.aws.memorydb.model.DeleteParameterGroupRequest
  ): IO[AwsError, zio.aws.memorydb.model.DeleteParameterGroupResponse.ReadOnly]
  def describeSnapshots(
      request: zio.aws.memorydb.model.DescribeSnapshotsRequest
  ): ZStream[Any, AwsError, zio.aws.memorydb.model.Snapshot.ReadOnly]
  def describeSnapshotsPaginated(
      request: zio.aws.memorydb.model.DescribeSnapshotsRequest
  ): IO[AwsError, zio.aws.memorydb.model.DescribeSnapshotsResponse.ReadOnly]
  def deleteSubnetGroup(
      request: zio.aws.memorydb.model.DeleteSubnetGroupRequest
  ): IO[AwsError, zio.aws.memorydb.model.DeleteSubnetGroupResponse.ReadOnly]
  def tagResource(
      request: zio.aws.memorydb.model.TagResourceRequest
  ): IO[AwsError, zio.aws.memorydb.model.TagResourceResponse.ReadOnly]
  def resetParameterGroup(
      request: zio.aws.memorydb.model.ResetParameterGroupRequest
  ): IO[AwsError, ReadOnly]
  def deleteUser(
      request: zio.aws.memorydb.model.DeleteUserRequest
  ): IO[AwsError, zio.aws.memorydb.model.DeleteUserResponse.ReadOnly]
  def createParameterGroup(
      request: zio.aws.memorydb.model.CreateParameterGroupRequest
  ): IO[AwsError, zio.aws.memorydb.model.CreateParameterGroupResponse.ReadOnly]
  def describeACLs(
      request: zio.aws.memorydb.model.DescribeAcLsRequest
  ): ZStream[Any, AwsError, zio.aws.memorydb.model.ACL.ReadOnly]
  def describeACLsPaginated(
      request: zio.aws.memorydb.model.DescribeAcLsRequest
  ): IO[AwsError, zio.aws.memorydb.model.DescribeAcLsResponse.ReadOnly]
  def updateSubnetGroup(
      request: zio.aws.memorydb.model.UpdateSubnetGroupRequest
  ): IO[AwsError, zio.aws.memorydb.model.UpdateSubnetGroupResponse.ReadOnly]
  def createSnapshot(
      request: zio.aws.memorydb.model.CreateSnapshotRequest
  ): IO[AwsError, zio.aws.memorydb.model.CreateSnapshotResponse.ReadOnly]
  def describeSubnetGroups(
      request: zio.aws.memorydb.model.DescribeSubnetGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.memorydb.model.SubnetGroup.ReadOnly]
  def describeSubnetGroupsPaginated(
      request: zio.aws.memorydb.model.DescribeSubnetGroupsRequest
  ): IO[AwsError, zio.aws.memorydb.model.DescribeSubnetGroupsResponse.ReadOnly]
  def describeEvents(
      request: zio.aws.memorydb.model.DescribeEventsRequest
  ): ZStream[Any, AwsError, zio.aws.memorydb.model.Event.ReadOnly]
  def describeEventsPaginated(
      request: zio.aws.memorydb.model.DescribeEventsRequest
  ): IO[AwsError, zio.aws.memorydb.model.DescribeEventsResponse.ReadOnly]
  def createSubnetGroup(
      request: zio.aws.memorydb.model.CreateSubnetGroupRequest
  ): IO[AwsError, zio.aws.memorydb.model.CreateSubnetGroupResponse.ReadOnly]
}
object MemoryDb {
  val live: ZLayer[AwsConfig, java.lang.Throwable, MemoryDb] = customized(
    identity
  )
  def customized(
      customization: MemoryDbAsyncClientBuilder => MemoryDbAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, MemoryDb] = managed(
    customization
  ).toLayer
  def managed(
      customization: MemoryDbAsyncClientBuilder => MemoryDbAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, MemoryDb] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = MemoryDbAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[MemoryDbAsyncClient, MemoryDbAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[MemoryDbAsyncClient, MemoryDbAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new MemoryDbImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class MemoryDbImpl[R](
      override val api: MemoryDbAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends MemoryDb
      with AwsServiceBase[R] {
    override val serviceName: String = "MemoryDb"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): MemoryDbImpl[R1] = new MemoryDbImpl(api, newAspect, r)
    def listAllowedNodeTypeUpdates(
        request: zio.aws.memorydb.model.ListAllowedNodeTypeUpdatesRequest
    ): IO[
      AwsError,
      zio.aws.memorydb.model.ListAllowedNodeTypeUpdatesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListAllowedNodeTypeUpdatesRequest,
      ListAllowedNodeTypeUpdatesResponse
    ]("listAllowedNodeTypeUpdates", api.listAllowedNodeTypeUpdates)(
      request.buildAwsValue()
    ).map(zio.aws.memorydb.model.ListAllowedNodeTypeUpdatesResponse.wrap)
      .provideEnvironment(r)
    def deleteACL(
        request: zio.aws.memorydb.model.DeleteAclRequest
    ): IO[AwsError, zio.aws.memorydb.model.DeleteAclResponse.ReadOnly] =
      asyncRequestResponse[DeleteAclRequest, DeleteAclResponse](
        "deleteACL",
        api.deleteACL
      )(request.buildAwsValue())
        .map(zio.aws.memorydb.model.DeleteAclResponse.wrap)
        .provideEnvironment(r)
    def describeClusters(
        request: zio.aws.memorydb.model.DescribeClustersRequest
    ): ZStream[Any, AwsError, zio.aws.memorydb.model.Cluster.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeClustersRequest,
        DescribeClustersResponse,
        Cluster
      ](
        "describeClusters",
        api.describeClusters,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.clusters().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.memorydb.model.Cluster.wrap(item))
        .provideEnvironment(r)
    def describeClustersPaginated(
        request: zio.aws.memorydb.model.DescribeClustersRequest
    ): IO[AwsError, zio.aws.memorydb.model.DescribeClustersResponse.ReadOnly] =
      asyncRequestResponse[DescribeClustersRequest, DescribeClustersResponse](
        "describeClusters",
        api.describeClusters
      )(request.buildAwsValue())
        .map(zio.aws.memorydb.model.DescribeClustersResponse.wrap)
        .provideEnvironment(r)
    def updateUser(
        request: zio.aws.memorydb.model.UpdateUserRequest
    ): IO[AwsError, zio.aws.memorydb.model.UpdateUserResponse.ReadOnly] =
      asyncRequestResponse[UpdateUserRequest, UpdateUserResponse](
        "updateUser",
        api.updateUser
      )(request.buildAwsValue())
        .map(zio.aws.memorydb.model.UpdateUserResponse.wrap)
        .provideEnvironment(r)
    def describeParameterGroups(
        request: zio.aws.memorydb.model.DescribeParameterGroupsRequest
    ): ZStream[Any, AwsError, zio.aws.memorydb.model.ParameterGroup.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeParameterGroupsRequest,
        DescribeParameterGroupsResponse,
        ParameterGroup
      ](
        "describeParameterGroups",
        api.describeParameterGroups,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.parameterGroups().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.memorydb.model.ParameterGroup.wrap(item))
        .provideEnvironment(r)
    def describeParameterGroupsPaginated(
        request: zio.aws.memorydb.model.DescribeParameterGroupsRequest
    ): IO[
      AwsError,
      zio.aws.memorydb.model.DescribeParameterGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeParameterGroupsRequest,
      DescribeParameterGroupsResponse
    ]("describeParameterGroups", api.describeParameterGroups)(
      request.buildAwsValue()
    ).map(zio.aws.memorydb.model.DescribeParameterGroupsResponse.wrap)
      .provideEnvironment(r)
    def batchUpdateCluster(
        request: zio.aws.memorydb.model.BatchUpdateClusterRequest
    ): IO[
      AwsError,
      zio.aws.memorydb.model.BatchUpdateClusterResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchUpdateClusterRequest,
      BatchUpdateClusterResponse
    ]("batchUpdateCluster", api.batchUpdateCluster)(request.buildAwsValue())
      .map(zio.aws.memorydb.model.BatchUpdateClusterResponse.wrap)
      .provideEnvironment(r)
    def listTags(
        request: zio.aws.memorydb.model.ListTagsRequest
    ): IO[AwsError, zio.aws.memorydb.model.ListTagsResponse.ReadOnly] =
      asyncRequestResponse[ListTagsRequest, ListTagsResponse](
        "listTags",
        api.listTags
      )(request.buildAwsValue())
        .map(zio.aws.memorydb.model.ListTagsResponse.wrap)
        .provideEnvironment(r)
    def describeParameters(
        request: zio.aws.memorydb.model.DescribeParametersRequest
    ): ZStream[Any, AwsError, zio.aws.memorydb.model.Parameter.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeParametersRequest,
        DescribeParametersResponse,
        Parameter
      ](
        "describeParameters",
        api.describeParameters,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.parameters().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.memorydb.model.Parameter.wrap(item))
        .provideEnvironment(r)
    def describeParametersPaginated(
        request: zio.aws.memorydb.model.DescribeParametersRequest
    ): IO[
      AwsError,
      zio.aws.memorydb.model.DescribeParametersResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeParametersRequest,
      DescribeParametersResponse
    ]("describeParameters", api.describeParameters)(request.buildAwsValue())
      .map(zio.aws.memorydb.model.DescribeParametersResponse.wrap)
      .provideEnvironment(r)
    def copySnapshot(
        request: zio.aws.memorydb.model.CopySnapshotRequest
    ): IO[AwsError, zio.aws.memorydb.model.CopySnapshotResponse.ReadOnly] =
      asyncRequestResponse[CopySnapshotRequest, CopySnapshotResponse](
        "copySnapshot",
        api.copySnapshot
      )(request.buildAwsValue())
        .map(zio.aws.memorydb.model.CopySnapshotResponse.wrap)
        .provideEnvironment(r)
    def createCluster(
        request: zio.aws.memorydb.model.CreateClusterRequest
    ): IO[AwsError, zio.aws.memorydb.model.CreateClusterResponse.ReadOnly] =
      asyncRequestResponse[CreateClusterRequest, CreateClusterResponse](
        "createCluster",
        api.createCluster
      )(request.buildAwsValue())
        .map(zio.aws.memorydb.model.CreateClusterResponse.wrap)
        .provideEnvironment(r)
    def deleteCluster(
        request: zio.aws.memorydb.model.DeleteClusterRequest
    ): IO[AwsError, zio.aws.memorydb.model.DeleteClusterResponse.ReadOnly] =
      asyncRequestResponse[DeleteClusterRequest, DeleteClusterResponse](
        "deleteCluster",
        api.deleteCluster
      )(request.buildAwsValue())
        .map(zio.aws.memorydb.model.DeleteClusterResponse.wrap)
        .provideEnvironment(r)
    def createACL(
        request: zio.aws.memorydb.model.CreateAclRequest
    ): IO[AwsError, zio.aws.memorydb.model.CreateAclResponse.ReadOnly] =
      asyncRequestResponse[CreateAclRequest, CreateAclResponse](
        "createACL",
        api.createACL
      )(request.buildAwsValue())
        .map(zio.aws.memorydb.model.CreateAclResponse.wrap)
        .provideEnvironment(r)
    def createUser(
        request: zio.aws.memorydb.model.CreateUserRequest
    ): IO[AwsError, zio.aws.memorydb.model.CreateUserResponse.ReadOnly] =
      asyncRequestResponse[CreateUserRequest, CreateUserResponse](
        "createUser",
        api.createUser
      )(request.buildAwsValue())
        .map(zio.aws.memorydb.model.CreateUserResponse.wrap)
        .provideEnvironment(r)
    def updateCluster(
        request: zio.aws.memorydb.model.UpdateClusterRequest
    ): IO[AwsError, zio.aws.memorydb.model.UpdateClusterResponse.ReadOnly] =
      asyncRequestResponse[UpdateClusterRequest, UpdateClusterResponse](
        "updateCluster",
        api.updateCluster
      )(request.buildAwsValue())
        .map(zio.aws.memorydb.model.UpdateClusterResponse.wrap)
        .provideEnvironment(r)
    def deleteSnapshot(
        request: zio.aws.memorydb.model.DeleteSnapshotRequest
    ): IO[AwsError, zio.aws.memorydb.model.DeleteSnapshotResponse.ReadOnly] =
      asyncRequestResponse[DeleteSnapshotRequest, DeleteSnapshotResponse](
        "deleteSnapshot",
        api.deleteSnapshot
      )(request.buildAwsValue())
        .map(zio.aws.memorydb.model.DeleteSnapshotResponse.wrap)
        .provideEnvironment(r)
    def updateParameterGroup(
        request: zio.aws.memorydb.model.UpdateParameterGroupRequest
    ): IO[
      AwsError,
      zio.aws.memorydb.model.UpdateParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateParameterGroupRequest,
      UpdateParameterGroupResponse
    ]("updateParameterGroup", api.updateParameterGroup)(request.buildAwsValue())
      .map(zio.aws.memorydb.model.UpdateParameterGroupResponse.wrap)
      .provideEnvironment(r)
    def describeServiceUpdates(
        request: zio.aws.memorydb.model.DescribeServiceUpdatesRequest
    ): ZStream[Any, AwsError, zio.aws.memorydb.model.ServiceUpdate.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeServiceUpdatesRequest,
        DescribeServiceUpdatesResponse,
        ServiceUpdate
      ](
        "describeServiceUpdates",
        api.describeServiceUpdates,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.serviceUpdates().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.memorydb.model.ServiceUpdate.wrap(item))
        .provideEnvironment(r)
    def describeServiceUpdatesPaginated(
        request: zio.aws.memorydb.model.DescribeServiceUpdatesRequest
    ): IO[
      AwsError,
      zio.aws.memorydb.model.DescribeServiceUpdatesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeServiceUpdatesRequest,
      DescribeServiceUpdatesResponse
    ]("describeServiceUpdates", api.describeServiceUpdates)(
      request.buildAwsValue()
    ).map(zio.aws.memorydb.model.DescribeServiceUpdatesResponse.wrap)
      .provideEnvironment(r)
    def describeUsers(
        request: zio.aws.memorydb.model.DescribeUsersRequest
    ): ZStream[Any, AwsError, zio.aws.memorydb.model.User.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeUsersRequest,
        DescribeUsersResponse,
        User
      ](
        "describeUsers",
        api.describeUsers,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.users().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.memorydb.model.User.wrap(item))
        .provideEnvironment(r)
    def describeUsersPaginated(
        request: zio.aws.memorydb.model.DescribeUsersRequest
    ): IO[AwsError, zio.aws.memorydb.model.DescribeUsersResponse.ReadOnly] =
      asyncRequestResponse[DescribeUsersRequest, DescribeUsersResponse](
        "describeUsers",
        api.describeUsers
      )(request.buildAwsValue())
        .map(zio.aws.memorydb.model.DescribeUsersResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.memorydb.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.memorydb.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.memorydb.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def failoverShard(
        request: zio.aws.memorydb.model.FailoverShardRequest
    ): IO[AwsError, zio.aws.memorydb.model.FailoverShardResponse.ReadOnly] =
      asyncRequestResponse[FailoverShardRequest, FailoverShardResponse](
        "failoverShard",
        api.failoverShard
      )(request.buildAwsValue())
        .map(zio.aws.memorydb.model.FailoverShardResponse.wrap)
        .provideEnvironment(r)
    def updateACL(
        request: zio.aws.memorydb.model.UpdateAclRequest
    ): IO[AwsError, zio.aws.memorydb.model.UpdateAclResponse.ReadOnly] =
      asyncRequestResponse[UpdateAclRequest, UpdateAclResponse](
        "updateACL",
        api.updateACL
      )(request.buildAwsValue())
        .map(zio.aws.memorydb.model.UpdateAclResponse.wrap)
        .provideEnvironment(r)
    def describeEngineVersions(
        request: zio.aws.memorydb.model.DescribeEngineVersionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.memorydb.model.EngineVersionInfo.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeEngineVersionsRequest,
      DescribeEngineVersionsResponse,
      EngineVersionInfo
    ](
      "describeEngineVersions",
      api.describeEngineVersions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.engineVersions().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.memorydb.model.EngineVersionInfo.wrap(item))
      .provideEnvironment(r)
    def describeEngineVersionsPaginated(
        request: zio.aws.memorydb.model.DescribeEngineVersionsRequest
    ): IO[
      AwsError,
      zio.aws.memorydb.model.DescribeEngineVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeEngineVersionsRequest,
      DescribeEngineVersionsResponse
    ]("describeEngineVersions", api.describeEngineVersions)(
      request.buildAwsValue()
    ).map(zio.aws.memorydb.model.DescribeEngineVersionsResponse.wrap)
      .provideEnvironment(r)
    def deleteParameterGroup(
        request: zio.aws.memorydb.model.DeleteParameterGroupRequest
    ): IO[
      AwsError,
      zio.aws.memorydb.model.DeleteParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteParameterGroupRequest,
      DeleteParameterGroupResponse
    ]("deleteParameterGroup", api.deleteParameterGroup)(request.buildAwsValue())
      .map(zio.aws.memorydb.model.DeleteParameterGroupResponse.wrap)
      .provideEnvironment(r)
    def describeSnapshots(
        request: zio.aws.memorydb.model.DescribeSnapshotsRequest
    ): ZStream[Any, AwsError, zio.aws.memorydb.model.Snapshot.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeSnapshotsRequest,
        DescribeSnapshotsResponse,
        Snapshot
      ](
        "describeSnapshots",
        api.describeSnapshots,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.snapshots().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.memorydb.model.Snapshot.wrap(item))
        .provideEnvironment(r)
    def describeSnapshotsPaginated(
        request: zio.aws.memorydb.model.DescribeSnapshotsRequest
    ): IO[AwsError, zio.aws.memorydb.model.DescribeSnapshotsResponse.ReadOnly] =
      asyncRequestResponse[DescribeSnapshotsRequest, DescribeSnapshotsResponse](
        "describeSnapshots",
        api.describeSnapshots
      )(request.buildAwsValue())
        .map(zio.aws.memorydb.model.DescribeSnapshotsResponse.wrap)
        .provideEnvironment(r)
    def deleteSubnetGroup(
        request: zio.aws.memorydb.model.DeleteSubnetGroupRequest
    ): IO[AwsError, zio.aws.memorydb.model.DeleteSubnetGroupResponse.ReadOnly] =
      asyncRequestResponse[DeleteSubnetGroupRequest, DeleteSubnetGroupResponse](
        "deleteSubnetGroup",
        api.deleteSubnetGroup
      )(request.buildAwsValue())
        .map(zio.aws.memorydb.model.DeleteSubnetGroupResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: zio.aws.memorydb.model.TagResourceRequest
    ): IO[AwsError, zio.aws.memorydb.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.memorydb.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def resetParameterGroup(
        request: zio.aws.memorydb.model.ResetParameterGroupRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      ResetParameterGroupRequest,
      ResetParameterGroupResponse
    ]("resetParameterGroup", api.resetParameterGroup)(request.buildAwsValue())
      .map(zio.aws.memorydb.model.ResetParameterGroupResponse.wrap)
      .provideEnvironment(r)
    def deleteUser(
        request: zio.aws.memorydb.model.DeleteUserRequest
    ): IO[AwsError, zio.aws.memorydb.model.DeleteUserResponse.ReadOnly] =
      asyncRequestResponse[DeleteUserRequest, DeleteUserResponse](
        "deleteUser",
        api.deleteUser
      )(request.buildAwsValue())
        .map(zio.aws.memorydb.model.DeleteUserResponse.wrap)
        .provideEnvironment(r)
    def createParameterGroup(
        request: zio.aws.memorydb.model.CreateParameterGroupRequest
    ): IO[
      AwsError,
      zio.aws.memorydb.model.CreateParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateParameterGroupRequest,
      CreateParameterGroupResponse
    ]("createParameterGroup", api.createParameterGroup)(request.buildAwsValue())
      .map(zio.aws.memorydb.model.CreateParameterGroupResponse.wrap)
      .provideEnvironment(r)
    def describeACLs(
        request: zio.aws.memorydb.model.DescribeAcLsRequest
    ): ZStream[Any, AwsError, zio.aws.memorydb.model.ACL.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeAcLsRequest,
        DescribeAcLsResponse,
        ACL
      ](
        "describeACLs",
        api.describeACLs,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.acLs().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.memorydb.model.ACL.wrap(item))
        .provideEnvironment(r)
    def describeACLsPaginated(
        request: zio.aws.memorydb.model.DescribeAcLsRequest
    ): IO[AwsError, zio.aws.memorydb.model.DescribeAcLsResponse.ReadOnly] =
      asyncRequestResponse[DescribeAcLsRequest, DescribeAcLsResponse](
        "describeACLs",
        api.describeACLs
      )(request.buildAwsValue())
        .map(zio.aws.memorydb.model.DescribeAcLsResponse.wrap)
        .provideEnvironment(r)
    def updateSubnetGroup(
        request: zio.aws.memorydb.model.UpdateSubnetGroupRequest
    ): IO[AwsError, zio.aws.memorydb.model.UpdateSubnetGroupResponse.ReadOnly] =
      asyncRequestResponse[UpdateSubnetGroupRequest, UpdateSubnetGroupResponse](
        "updateSubnetGroup",
        api.updateSubnetGroup
      )(request.buildAwsValue())
        .map(zio.aws.memorydb.model.UpdateSubnetGroupResponse.wrap)
        .provideEnvironment(r)
    def createSnapshot(
        request: zio.aws.memorydb.model.CreateSnapshotRequest
    ): IO[AwsError, zio.aws.memorydb.model.CreateSnapshotResponse.ReadOnly] =
      asyncRequestResponse[CreateSnapshotRequest, CreateSnapshotResponse](
        "createSnapshot",
        api.createSnapshot
      )(request.buildAwsValue())
        .map(zio.aws.memorydb.model.CreateSnapshotResponse.wrap)
        .provideEnvironment(r)
    def describeSubnetGroups(
        request: zio.aws.memorydb.model.DescribeSubnetGroupsRequest
    ): ZStream[Any, AwsError, zio.aws.memorydb.model.SubnetGroup.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeSubnetGroupsRequest,
        DescribeSubnetGroupsResponse,
        SubnetGroup
      ](
        "describeSubnetGroups",
        api.describeSubnetGroups,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.subnetGroups().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.memorydb.model.SubnetGroup.wrap(item))
        .provideEnvironment(r)
    def describeSubnetGroupsPaginated(
        request: zio.aws.memorydb.model.DescribeSubnetGroupsRequest
    ): IO[
      AwsError,
      zio.aws.memorydb.model.DescribeSubnetGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeSubnetGroupsRequest,
      DescribeSubnetGroupsResponse
    ]("describeSubnetGroups", api.describeSubnetGroups)(request.buildAwsValue())
      .map(zio.aws.memorydb.model.DescribeSubnetGroupsResponse.wrap)
      .provideEnvironment(r)
    def describeEvents(
        request: zio.aws.memorydb.model.DescribeEventsRequest
    ): ZStream[Any, AwsError, zio.aws.memorydb.model.Event.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeEventsRequest,
        DescribeEventsResponse,
        Event
      ](
        "describeEvents",
        api.describeEvents,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.events().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.memorydb.model.Event.wrap(item))
        .provideEnvironment(r)
    def describeEventsPaginated(
        request: zio.aws.memorydb.model.DescribeEventsRequest
    ): IO[AwsError, zio.aws.memorydb.model.DescribeEventsResponse.ReadOnly] =
      asyncRequestResponse[DescribeEventsRequest, DescribeEventsResponse](
        "describeEvents",
        api.describeEvents
      )(request.buildAwsValue())
        .map(zio.aws.memorydb.model.DescribeEventsResponse.wrap)
        .provideEnvironment(r)
    def createSubnetGroup(
        request: zio.aws.memorydb.model.CreateSubnetGroupRequest
    ): IO[AwsError, zio.aws.memorydb.model.CreateSubnetGroupResponse.ReadOnly] =
      asyncRequestResponse[CreateSubnetGroupRequest, CreateSubnetGroupResponse](
        "createSubnetGroup",
        api.createSubnetGroup
      )(request.buildAwsValue())
        .map(zio.aws.memorydb.model.CreateSubnetGroupResponse.wrap)
        .provideEnvironment(r)
  }
  def listAllowedNodeTypeUpdates(
      request: zio.aws.memorydb.model.ListAllowedNodeTypeUpdatesRequest
  ): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.ListAllowedNodeTypeUpdatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAllowedNodeTypeUpdates(request))
  def deleteACL(request: zio.aws.memorydb.model.DeleteAclRequest): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.DeleteAclResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteACL(request))
  def describeClusters(
      request: zio.aws.memorydb.model.DescribeClustersRequest
  ): ZStream[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.Cluster.ReadOnly
  ] = ZStream.serviceWithStream(_.describeClusters(request))
  def describeClustersPaginated(
      request: zio.aws.memorydb.model.DescribeClustersRequest
  ): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.DescribeClustersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeClustersPaginated(request))
  def updateUser(request: zio.aws.memorydb.model.UpdateUserRequest): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.UpdateUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateUser(request))
  def describeParameterGroups(
      request: zio.aws.memorydb.model.DescribeParameterGroupsRequest
  ): ZStream[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.ParameterGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeParameterGroups(request))
  def describeParameterGroupsPaginated(
      request: zio.aws.memorydb.model.DescribeParameterGroupsRequest
  ): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.DescribeParameterGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeParameterGroupsPaginated(request))
  def batchUpdateCluster(
      request: zio.aws.memorydb.model.BatchUpdateClusterRequest
  ): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.BatchUpdateClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchUpdateCluster(request))
  def listTags(request: zio.aws.memorydb.model.ListTagsRequest): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.ListTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTags(request))
  def describeParameters(
      request: zio.aws.memorydb.model.DescribeParametersRequest
  ): ZStream[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.Parameter.ReadOnly
  ] = ZStream.serviceWithStream(_.describeParameters(request))
  def describeParametersPaginated(
      request: zio.aws.memorydb.model.DescribeParametersRequest
  ): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.DescribeParametersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeParametersPaginated(request))
  def copySnapshot(request: zio.aws.memorydb.model.CopySnapshotRequest): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.CopySnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.copySnapshot(request))
  def createCluster(request: zio.aws.memorydb.model.CreateClusterRequest): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.CreateClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCluster(request))
  def deleteCluster(request: zio.aws.memorydb.model.DeleteClusterRequest): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.DeleteClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCluster(request))
  def createACL(request: zio.aws.memorydb.model.CreateAclRequest): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.CreateAclResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createACL(request))
  def createUser(request: zio.aws.memorydb.model.CreateUserRequest): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.CreateUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUser(request))
  def updateCluster(request: zio.aws.memorydb.model.UpdateClusterRequest): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.UpdateClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateCluster(request))
  def deleteSnapshot(
      request: zio.aws.memorydb.model.DeleteSnapshotRequest
  ): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.DeleteSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSnapshot(request))
  def updateParameterGroup(
      request: zio.aws.memorydb.model.UpdateParameterGroupRequest
  ): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.UpdateParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateParameterGroup(request))
  def describeServiceUpdates(
      request: zio.aws.memorydb.model.DescribeServiceUpdatesRequest
  ): ZStream[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.ServiceUpdate.ReadOnly
  ] = ZStream.serviceWithStream(_.describeServiceUpdates(request))
  def describeServiceUpdatesPaginated(
      request: zio.aws.memorydb.model.DescribeServiceUpdatesRequest
  ): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.DescribeServiceUpdatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeServiceUpdatesPaginated(request))
  def describeUsers(
      request: zio.aws.memorydb.model.DescribeUsersRequest
  ): ZStream[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.User.ReadOnly
  ] = ZStream.serviceWithStream(_.describeUsers(request))
  def describeUsersPaginated(
      request: zio.aws.memorydb.model.DescribeUsersRequest
  ): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.DescribeUsersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeUsersPaginated(request))
  def untagResource(request: zio.aws.memorydb.model.UntagResourceRequest): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def failoverShard(request: zio.aws.memorydb.model.FailoverShardRequest): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.FailoverShardResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.failoverShard(request))
  def updateACL(request: zio.aws.memorydb.model.UpdateAclRequest): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.UpdateAclResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateACL(request))
  def describeEngineVersions(
      request: zio.aws.memorydb.model.DescribeEngineVersionsRequest
  ): ZStream[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.EngineVersionInfo.ReadOnly
  ] = ZStream.serviceWithStream(_.describeEngineVersions(request))
  def describeEngineVersionsPaginated(
      request: zio.aws.memorydb.model.DescribeEngineVersionsRequest
  ): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.DescribeEngineVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEngineVersionsPaginated(request))
  def deleteParameterGroup(
      request: zio.aws.memorydb.model.DeleteParameterGroupRequest
  ): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.DeleteParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteParameterGroup(request))
  def describeSnapshots(
      request: zio.aws.memorydb.model.DescribeSnapshotsRequest
  ): ZStream[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.Snapshot.ReadOnly
  ] = ZStream.serviceWithStream(_.describeSnapshots(request))
  def describeSnapshotsPaginated(
      request: zio.aws.memorydb.model.DescribeSnapshotsRequest
  ): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.DescribeSnapshotsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSnapshotsPaginated(request))
  def deleteSubnetGroup(
      request: zio.aws.memorydb.model.DeleteSubnetGroupRequest
  ): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.DeleteSubnetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSubnetGroup(request))
  def tagResource(request: zio.aws.memorydb.model.TagResourceRequest): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def resetParameterGroup(
      request: zio.aws.memorydb.model.ResetParameterGroupRequest
  ): ZIO[zio.aws.memorydb.MemoryDb, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.resetParameterGroup(request))
  def deleteUser(request: zio.aws.memorydb.model.DeleteUserRequest): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.DeleteUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteUser(request))
  def createParameterGroup(
      request: zio.aws.memorydb.model.CreateParameterGroupRequest
  ): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.CreateParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createParameterGroup(request))
  def describeACLs(
      request: zio.aws.memorydb.model.DescribeAcLsRequest
  ): ZStream[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.ACL.ReadOnly
  ] = ZStream.serviceWithStream(_.describeACLs(request))
  def describeACLsPaginated(
      request: zio.aws.memorydb.model.DescribeAcLsRequest
  ): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.DescribeAcLsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeACLsPaginated(request))
  def updateSubnetGroup(
      request: zio.aws.memorydb.model.UpdateSubnetGroupRequest
  ): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.UpdateSubnetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSubnetGroup(request))
  def createSnapshot(
      request: zio.aws.memorydb.model.CreateSnapshotRequest
  ): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.CreateSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSnapshot(request))
  def describeSubnetGroups(
      request: zio.aws.memorydb.model.DescribeSubnetGroupsRequest
  ): ZStream[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.SubnetGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeSubnetGroups(request))
  def describeSubnetGroupsPaginated(
      request: zio.aws.memorydb.model.DescribeSubnetGroupsRequest
  ): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.DescribeSubnetGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSubnetGroupsPaginated(request))
  def describeEvents(
      request: zio.aws.memorydb.model.DescribeEventsRequest
  ): ZStream[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.Event.ReadOnly
  ] = ZStream.serviceWithStream(_.describeEvents(request))
  def describeEventsPaginated(
      request: zio.aws.memorydb.model.DescribeEventsRequest
  ): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.DescribeEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventsPaginated(request))
  def createSubnetGroup(
      request: zio.aws.memorydb.model.CreateSubnetGroupRequest
  ): ZIO[
    zio.aws.memorydb.MemoryDb,
    AwsError,
    zio.aws.memorydb.model.CreateSubnetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSubnetGroup(request))
}
