package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeParametersResponse(
    nextToken: Option[String] = None,
    parameters: Option[Iterable[zio.aws.memorydb.model.Parameter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeParametersResponse = {
    import DescribeParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeParametersResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.DescribeParametersResponse.ReadOnly =
    zio.aws.memorydb.model.DescribeParametersResponse.wrap(buildAwsValue())
}
object DescribeParametersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeParametersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DescribeParametersResponse =
      zio.aws.memorydb.model.DescribeParametersResponse(
        nextToken.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[String]
    def parameters: Option[List[zio.aws.memorydb.model.Parameter.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getParameters
        : ZIO[Any, AwsError, List[zio.aws.memorydb.model.Parameter.ReadOnly]] =
      AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeParametersResponse
  ) extends zio.aws.memorydb.model.DescribeParametersResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val parameters
        : Option[List[zio.aws.memorydb.model.Parameter.ReadOnly]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.memorydb.model.Parameter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeParametersResponse
  ): zio.aws.memorydb.model.DescribeParametersResponse.ReadOnly = new Wrapper(
    impl
  )
}
