package zio.aws.memorydb.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.memorydb.model.primitives.IntegerOptional
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeParameterGroupsRequest(
    parameterGroupName: Optional[String] = Optional.Absent,
    maxResults: Optional[IntegerOptional] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsRequest = {
    import DescribeParameterGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsRequest
      .builder()
      .optionallyWith(parameterGroupName.map(value => value: java.lang.String))(
        _.parameterGroupName
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.memorydb.model.DescribeParameterGroupsRequest.ReadOnly =
    zio.aws.memorydb.model.DescribeParameterGroupsRequest.wrap(buildAwsValue())
}
object DescribeParameterGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DescribeParameterGroupsRequest =
      zio.aws.memorydb.model.DescribeParameterGroupsRequest(
        parameterGroupName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def parameterGroupName: Optional[String]
    def maxResults: Optional[IntegerOptional]
    def nextToken: Optional[String]
    def getParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupName)
    def getMaxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsRequest
  ) extends zio.aws.memorydb.model.DescribeParameterGroupsRequest.ReadOnly {
    override val parameterGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterGroupName())
      .map(value => value: String)
    override val maxResults: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: IntegerOptional)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsRequest
  ): zio.aws.memorydb.model.DescribeParameterGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
