package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.memorydb.model.primitives.ACLName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ACLsUpdateStatus(
    aclToApply: Optional[ACLName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ACLsUpdateStatus = {
    import ACLsUpdateStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ACLsUpdateStatus
      .builder()
      .optionallyWith(
        aclToApply.map(value => ACLName.unwrap(value): java.lang.String)
      )(_.aclToApply)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.ACLsUpdateStatus.ReadOnly =
    zio.aws.memorydb.model.ACLsUpdateStatus.wrap(buildAwsValue())
}
object ACLsUpdateStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ACLsUpdateStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.ACLsUpdateStatus =
      zio.aws.memorydb.model.ACLsUpdateStatus(aclToApply.map(value => value))
    def aclToApply: Optional[ACLName]
    def getAclToApply: ZIO[Any, AwsError, ACLName] =
      AwsError.unwrapOptionField("aclToApply", aclToApply)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ACLsUpdateStatus
  ) extends zio.aws.memorydb.model.ACLsUpdateStatus.ReadOnly {
    override val aclToApply: Optional[ACLName] = zio.aws.core.internal
      .optionalFromNullable(impl.aclToApply())
      .map(value => zio.aws.memorydb.model.primitives.ACLName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ACLsUpdateStatus
  ): zio.aws.memorydb.model.ACLsUpdateStatus.ReadOnly = new Wrapper(impl)
}
