package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ParameterNameValue(
    parameterName: Optional[String] = Optional.Absent,
    parameterValue: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ParameterNameValue = {
    import ParameterNameValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ParameterNameValue
      .builder()
      .optionallyWith(parameterName.map(value => value: java.lang.String))(
        _.parameterName
      )
      .optionallyWith(parameterValue.map(value => value: java.lang.String))(
        _.parameterValue
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.ParameterNameValue.ReadOnly =
    zio.aws.memorydb.model.ParameterNameValue.wrap(buildAwsValue())
}
object ParameterNameValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ParameterNameValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.ParameterNameValue =
      zio.aws.memorydb.model.ParameterNameValue(
        parameterName.map(value => value),
        parameterValue.map(value => value)
      )
    def parameterName: Optional[String]
    def parameterValue: Optional[String]
    def getParameterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterName", parameterName)
    def getParameterValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterValue", parameterValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ParameterNameValue
  ) extends zio.aws.memorydb.model.ParameterNameValue.ReadOnly {
    override val parameterName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterName())
      .map(value => value: String)
    override val parameterValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterValue())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ParameterNameValue
  ): zio.aws.memorydb.model.ParameterNameValue.ReadOnly = new Wrapper(impl)
}
