package zio.aws.memorydb.model
import scala.jdk.CollectionConverters._
sealed trait InputAuthenticationType {
  def unwrap
      : software.amazon.awssdk.services.memorydb.model.InputAuthenticationType
}
object InputAuthenticationType {
  def wrap(
      value: software.amazon.awssdk.services.memorydb.model.InputAuthenticationType
  ): zio.aws.memorydb.model.InputAuthenticationType = value match {
    case software.amazon.awssdk.services.memorydb.model.InputAuthenticationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.memorydb.model.InputAuthenticationType.PASSWORD =>
      val r = password
      r
    case software.amazon.awssdk.services.memorydb.model.InputAuthenticationType.IAM =>
      val r = iam
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.memorydb.model.InputAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.memorydb.model.InputAuthenticationType =
      software.amazon.awssdk.services.memorydb.model.InputAuthenticationType.UNKNOWN_TO_SDK_VERSION
  }
  case object password extends zio.aws.memorydb.model.InputAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.memorydb.model.InputAuthenticationType =
      software.amazon.awssdk.services.memorydb.model.InputAuthenticationType.PASSWORD
  }
  case object iam extends zio.aws.memorydb.model.InputAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.memorydb.model.InputAuthenticationType =
      software.amazon.awssdk.services.memorydb.model.InputAuthenticationType.IAM
  }
}
