package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.memorydb.model.primitives.{AccessString, UserName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateUserRequest(
    userName: UserName,
    authenticationMode: Optional[zio.aws.memorydb.model.AuthenticationMode] =
      Optional.Absent,
    accessString: Optional[AccessString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.UpdateUserRequest = {
    import UpdateUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.UpdateUserRequest
      .builder()
      .userName(UserName.unwrap(userName): java.lang.String)
      .optionallyWith(authenticationMode.map(value => value.buildAwsValue()))(
        _.authenticationMode
      )
      .optionallyWith(
        accessString.map(value => AccessString.unwrap(value): java.lang.String)
      )(_.accessString)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.UpdateUserRequest.ReadOnly =
    zio.aws.memorydb.model.UpdateUserRequest.wrap(buildAwsValue())
}
object UpdateUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.UpdateUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.UpdateUserRequest =
      zio.aws.memorydb.model.UpdateUserRequest(
        userName,
        authenticationMode.map(value => value.asEditable),
        accessString.map(value => value)
      )
    def userName: UserName
    def authenticationMode
        : Optional[zio.aws.memorydb.model.AuthenticationMode.ReadOnly]
    def accessString: Optional[AccessString]
    def getUserName: ZIO[Any, Nothing, UserName] = ZIO.succeed(userName)
    def getAuthenticationMode: ZIO[
      Any,
      AwsError,
      zio.aws.memorydb.model.AuthenticationMode.ReadOnly
    ] = AwsError.unwrapOptionField("authenticationMode", authenticationMode)
    def getAccessString: ZIO[Any, AwsError, AccessString] =
      AwsError.unwrapOptionField("accessString", accessString)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateUserRequest
  ) extends zio.aws.memorydb.model.UpdateUserRequest.ReadOnly {
    override val userName: UserName =
      zio.aws.memorydb.model.primitives.UserName(impl.userName())
    override val authenticationMode
        : Optional[zio.aws.memorydb.model.AuthenticationMode.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationMode())
        .map(value => zio.aws.memorydb.model.AuthenticationMode.wrap(value))
    override val accessString: Optional[AccessString] = zio.aws.core.internal
      .optionalFromNullable(impl.accessString())
      .map(value => zio.aws.memorydb.model.primitives.AccessString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateUserRequest
  ): zio.aws.memorydb.model.UpdateUserRequest.ReadOnly = new Wrapper(impl)
}
