package zio.aws.memorydb.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.memorydb.model.primitives.IntegerOptional
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeReservedNodesRequest(
    reservationId: Optional[String] = Optional.Absent,
    reservedNodesOfferingId: Optional[String] = Optional.Absent,
    nodeType: Optional[String] = Optional.Absent,
    duration: Optional[String] = Optional.Absent,
    offeringType: Optional[String] = Optional.Absent,
    maxResults: Optional[IntegerOptional] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesRequest = {
    import DescribeReservedNodesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesRequest
      .builder()
      .optionallyWith(reservationId.map(value => value: java.lang.String))(
        _.reservationId
      )
      .optionallyWith(
        reservedNodesOfferingId.map(value => value: java.lang.String)
      )(_.reservedNodesOfferingId)
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(duration.map(value => value: java.lang.String))(
        _.duration
      )
      .optionallyWith(offeringType.map(value => value: java.lang.String))(
        _.offeringType
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.DescribeReservedNodesRequest.ReadOnly =
    zio.aws.memorydb.model.DescribeReservedNodesRequest.wrap(buildAwsValue())
}
object DescribeReservedNodesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DescribeReservedNodesRequest =
      zio.aws.memorydb.model.DescribeReservedNodesRequest(
        reservationId.map(value => value),
        reservedNodesOfferingId.map(value => value),
        nodeType.map(value => value),
        duration.map(value => value),
        offeringType.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def reservationId: Optional[String]
    def reservedNodesOfferingId: Optional[String]
    def nodeType: Optional[String]
    def duration: Optional[String]
    def offeringType: Optional[String]
    def maxResults: Optional[IntegerOptional]
    def nextToken: Optional[String]
    def getReservationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservationId", reservationId)
    def getReservedNodesOfferingId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("reservedNodesOfferingId", reservedNodesOfferingId)
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getDuration: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("duration", duration)
    def getOfferingType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("offeringType", offeringType)
    def getMaxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesRequest
  ) extends zio.aws.memorydb.model.DescribeReservedNodesRequest.ReadOnly {
    override val reservationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reservationId())
      .map(value => value: String)
    override val reservedNodesOfferingId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedNodesOfferingId())
        .map(value => value: String)
    override val nodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeType())
      .map(value => value: String)
    override val duration: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: String)
    override val offeringType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.offeringType())
      .map(value => value: String)
    override val maxResults: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: IntegerOptional)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesRequest
  ): zio.aws.memorydb.model.DescribeReservedNodesRequest.ReadOnly = new Wrapper(
    impl
  )
}
