package zio.aws.memorydb.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.memorydb.model.primitives.IntegerOptional
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeServiceUpdatesRequest(
    serviceUpdateName: Optional[String] = Optional.Absent,
    clusterNames: Optional[Iterable[String]] = Optional.Absent,
    status: Optional[Iterable[zio.aws.memorydb.model.ServiceUpdateStatus]] =
      Optional.Absent,
    maxResults: Optional[IntegerOptional] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesRequest = {
    import DescribeServiceUpdatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesRequest
      .builder()
      .optionallyWith(serviceUpdateName.map(value => value: java.lang.String))(
        _.serviceUpdateName
      )
      .optionallyWith(
        clusterNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.clusterNames)
      .optionallyWith(
        status.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.statusWithStrings)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.memorydb.model.DescribeServiceUpdatesRequest.ReadOnly =
    zio.aws.memorydb.model.DescribeServiceUpdatesRequest.wrap(buildAwsValue())
}
object DescribeServiceUpdatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DescribeServiceUpdatesRequest =
      zio.aws.memorydb.model.DescribeServiceUpdatesRequest(
        serviceUpdateName.map(value => value),
        clusterNames.map(value => value),
        status.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def serviceUpdateName: Optional[String]
    def clusterNames: Optional[List[String]]
    def status: Optional[List[zio.aws.memorydb.model.ServiceUpdateStatus]]
    def maxResults: Optional[IntegerOptional]
    def nextToken: Optional[String]
    def getServiceUpdateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceUpdateName", serviceUpdateName)
    def getClusterNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("clusterNames", clusterNames)
    def getStatus
        : ZIO[Any, AwsError, List[zio.aws.memorydb.model.ServiceUpdateStatus]] =
      AwsError.unwrapOptionField("status", status)
    def getMaxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesRequest
  ) extends zio.aws.memorydb.model.DescribeServiceUpdatesRequest.ReadOnly {
    override val serviceUpdateName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceUpdateName())
      .map(value => value: String)
    override val clusterNames: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val status
        : Optional[List[zio.aws.memorydb.model.ServiceUpdateStatus]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.memorydb.model.ServiceUpdateStatus.wrap(item)
          }.toList
        )
    override val maxResults: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: IntegerOptional)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesRequest
  ): zio.aws.memorydb.model.DescribeServiceUpdatesRequest.ReadOnly =
    new Wrapper(impl)
}
