package zio.aws.memorydb.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.memorydb.model.primitives.{Integer, TStamp}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ReservedNode(
    reservationId: Optional[String] = Optional.Absent,
    reservedNodesOfferingId: Optional[String] = Optional.Absent,
    nodeType: Optional[String] = Optional.Absent,
    startTime: Optional[TStamp] = Optional.Absent,
    duration: Optional[Integer] = Optional.Absent,
    fixedPrice: Optional[Double] = Optional.Absent,
    nodeCount: Optional[Integer] = Optional.Absent,
    offeringType: Optional[String] = Optional.Absent,
    state: Optional[String] = Optional.Absent,
    recurringCharges: Optional[
      Iterable[zio.aws.memorydb.model.RecurringCharge]
    ] = Optional.Absent,
    arn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ReservedNode = {
    import ReservedNode.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ReservedNode
      .builder()
      .optionallyWith(reservationId.map(value => value: java.lang.String))(
        _.reservationId
      )
      .optionallyWith(
        reservedNodesOfferingId.map(value => value: java.lang.String)
      )(_.reservedNodesOfferingId)
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(startTime.map(value => TStamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(duration.map(value => value: java.lang.Integer))(
        _.duration
      )
      .optionallyWith(fixedPrice.map(value => value: java.lang.Double))(
        _.fixedPrice
      )
      .optionallyWith(nodeCount.map(value => value: java.lang.Integer))(
        _.nodeCount
      )
      .optionallyWith(offeringType.map(value => value: java.lang.String))(
        _.offeringType
      )
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(
        recurringCharges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recurringCharges)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.ReservedNode.ReadOnly =
    zio.aws.memorydb.model.ReservedNode.wrap(buildAwsValue())
}
object ReservedNode {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ReservedNode
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.ReservedNode =
      zio.aws.memorydb.model.ReservedNode(
        reservationId.map(value => value),
        reservedNodesOfferingId.map(value => value),
        nodeType.map(value => value),
        startTime.map(value => value),
        duration.map(value => value),
        fixedPrice.map(value => value),
        nodeCount.map(value => value),
        offeringType.map(value => value),
        state.map(value => value),
        recurringCharges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        arn.map(value => value)
      )
    def reservationId: Optional[String]
    def reservedNodesOfferingId: Optional[String]
    def nodeType: Optional[String]
    def startTime: Optional[TStamp]
    def duration: Optional[Integer]
    def fixedPrice: Optional[Double]
    def nodeCount: Optional[Integer]
    def offeringType: Optional[String]
    def state: Optional[String]
    def recurringCharges
        : Optional[List[zio.aws.memorydb.model.RecurringCharge.ReadOnly]]
    def arn: Optional[String]
    def getReservationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservationId", reservationId)
    def getReservedNodesOfferingId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("reservedNodesOfferingId", reservedNodesOfferingId)
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getDuration: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("duration", duration)
    def getFixedPrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("fixedPrice", fixedPrice)
    def getNodeCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("nodeCount", nodeCount)
    def getOfferingType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("offeringType", offeringType)
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
    def getRecurringCharges: ZIO[Any, AwsError, List[
      zio.aws.memorydb.model.RecurringCharge.ReadOnly
    ]] = AwsError.unwrapOptionField("recurringCharges", recurringCharges)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ReservedNode
  ) extends zio.aws.memorydb.model.ReservedNode.ReadOnly {
    override val reservationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reservationId())
      .map(value => value: String)
    override val reservedNodesOfferingId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedNodesOfferingId())
        .map(value => value: String)
    override val nodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeType())
      .map(value => value: String)
    override val startTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.memorydb.model.primitives.TStamp(value))
    override val duration: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: Integer)
    override val fixedPrice: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.fixedPrice())
      .map(value => value: Double)
    override val nodeCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeCount())
      .map(value => value: Integer)
    override val offeringType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.offeringType())
      .map(value => value: String)
    override val state: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => value: String)
    override val recurringCharges
        : Optional[List[zio.aws.memorydb.model.RecurringCharge.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recurringCharges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.memorydb.model.RecurringCharge.wrap(item)
          }.toList
        )
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ReservedNode
  ): zio.aws.memorydb.model.ReservedNode.ReadOnly = new Wrapper(impl)
}
