package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateSubnetGroupRequest(
    subnetGroupName: String,
    description: Optional[String] = Optional.Absent,
    subnetIds: Iterable[String],
    tags: Optional[Iterable[zio.aws.memorydb.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupRequest = {
    import CreateSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupRequest
      .builder()
      .subnetGroupName(subnetGroupName: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .subnetIds(subnetIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.CreateSubnetGroupRequest.ReadOnly =
    zio.aws.memorydb.model.CreateSubnetGroupRequest.wrap(buildAwsValue())
}
object CreateSubnetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.CreateSubnetGroupRequest =
      zio.aws.memorydb.model.CreateSubnetGroupRequest(
        subnetGroupName,
        description.map(value => value),
        subnetIds,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def subnetGroupName: String
    def description: Optional[String]
    def subnetIds: List[String]
    def tags: Optional[List[zio.aws.memorydb.model.Tag.ReadOnly]]
    def getSubnetGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(subnetGroupName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSubnetIds: ZIO[Any, Nothing, List[String]] = ZIO.succeed(subnetIds)
    def getTags: ZIO[Any, AwsError, List[zio.aws.memorydb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupRequest
  ) extends zio.aws.memorydb.model.CreateSubnetGroupRequest.ReadOnly {
    override val subnetGroupName: String = impl.subnetGroupName(): String
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val subnetIds: List[String] = impl
      .subnetIds()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val tags: Optional[List[zio.aws.memorydb.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.memorydb.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupRequest
  ): zio.aws.memorydb.model.CreateSubnetGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
