package zio.aws.memorydb.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.memorydb.model.primitives.IntegerOptional
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class PurchaseReservedNodesOfferingRequest(
    reservedNodesOfferingId: String,
    reservationId: Optional[String] = Optional.Absent,
    nodeCount: Optional[IntegerOptional] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.memorydb.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.PurchaseReservedNodesOfferingRequest = {
    import PurchaseReservedNodesOfferingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.PurchaseReservedNodesOfferingRequest
      .builder()
      .reservedNodesOfferingId(reservedNodesOfferingId: java.lang.String)
      .optionallyWith(reservationId.map(value => value: java.lang.String))(
        _.reservationId
      )
      .optionallyWith(nodeCount.map(value => value: Integer))(_.nodeCount)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.memorydb.model.PurchaseReservedNodesOfferingRequest.ReadOnly =
    zio.aws.memorydb.model.PurchaseReservedNodesOfferingRequest
      .wrap(buildAwsValue())
}
object PurchaseReservedNodesOfferingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.PurchaseReservedNodesOfferingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.memorydb.model.PurchaseReservedNodesOfferingRequest =
      zio.aws.memorydb.model.PurchaseReservedNodesOfferingRequest(
        reservedNodesOfferingId,
        reservationId.map(value => value),
        nodeCount.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def reservedNodesOfferingId: String
    def reservationId: Optional[String]
    def nodeCount: Optional[IntegerOptional]
    def tags: Optional[List[zio.aws.memorydb.model.Tag.ReadOnly]]
    def getReservedNodesOfferingId: ZIO[Any, Nothing, String] =
      ZIO.succeed(reservedNodesOfferingId)
    def getReservationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservationId", reservationId)
    def getNodeCount: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("nodeCount", nodeCount)
    def getTags: ZIO[Any, AwsError, List[zio.aws.memorydb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.PurchaseReservedNodesOfferingRequest
  ) extends zio.aws.memorydb.model.PurchaseReservedNodesOfferingRequest.ReadOnly {
    override val reservedNodesOfferingId: String =
      impl.reservedNodesOfferingId(): String
    override val reservationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reservationId())
      .map(value => value: String)
    override val nodeCount: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeCount())
      .map(value => value: IntegerOptional)
    override val tags: Optional[List[zio.aws.memorydb.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.memorydb.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.PurchaseReservedNodesOfferingRequest
  ): zio.aws.memorydb.model.PurchaseReservedNodesOfferingRequest.ReadOnly =
    new Wrapper(impl)
}
