package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.memorydb.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReservedNodesOffering(
    reservedNodesOfferingId: Optional[String] = Optional.Absent,
    nodeType: Optional[String] = Optional.Absent,
    duration: Optional[Integer] = Optional.Absent,
    fixedPrice: Optional[Double] = Optional.Absent,
    offeringType: Optional[String] = Optional.Absent,
    recurringCharges: Optional[
      Iterable[zio.aws.memorydb.model.RecurringCharge]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ReservedNodesOffering = {
    import ReservedNodesOffering.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ReservedNodesOffering
      .builder()
      .optionallyWith(
        reservedNodesOfferingId.map(value => value: java.lang.String)
      )(_.reservedNodesOfferingId)
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(duration.map(value => value: java.lang.Integer))(
        _.duration
      )
      .optionallyWith(fixedPrice.map(value => value: java.lang.Double))(
        _.fixedPrice
      )
      .optionallyWith(offeringType.map(value => value: java.lang.String))(
        _.offeringType
      )
      .optionallyWith(
        recurringCharges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recurringCharges)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.ReservedNodesOffering.ReadOnly =
    zio.aws.memorydb.model.ReservedNodesOffering.wrap(buildAwsValue())
}
object ReservedNodesOffering {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ReservedNodesOffering
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.ReservedNodesOffering =
      zio.aws.memorydb.model.ReservedNodesOffering(
        reservedNodesOfferingId.map(value => value),
        nodeType.map(value => value),
        duration.map(value => value),
        fixedPrice.map(value => value),
        offeringType.map(value => value),
        recurringCharges.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def reservedNodesOfferingId: Optional[String]
    def nodeType: Optional[String]
    def duration: Optional[Integer]
    def fixedPrice: Optional[Double]
    def offeringType: Optional[String]
    def recurringCharges
        : Optional[List[zio.aws.memorydb.model.RecurringCharge.ReadOnly]]
    def getReservedNodesOfferingId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("reservedNodesOfferingId", reservedNodesOfferingId)
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getDuration: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("duration", duration)
    def getFixedPrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("fixedPrice", fixedPrice)
    def getOfferingType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("offeringType", offeringType)
    def getRecurringCharges: ZIO[Any, AwsError, List[
      zio.aws.memorydb.model.RecurringCharge.ReadOnly
    ]] = AwsError.unwrapOptionField("recurringCharges", recurringCharges)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ReservedNodesOffering
  ) extends zio.aws.memorydb.model.ReservedNodesOffering.ReadOnly {
    override val reservedNodesOfferingId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedNodesOfferingId())
        .map(value => value: String)
    override val nodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeType())
      .map(value => value: String)
    override val duration: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: Integer)
    override val fixedPrice: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.fixedPrice())
      .map(value => value: Double)
    override val offeringType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.offeringType())
      .map(value => value: String)
    override val recurringCharges
        : Optional[List[zio.aws.memorydb.model.RecurringCharge.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recurringCharges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.memorydb.model.RecurringCharge.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ReservedNodesOffering
  ): zio.aws.memorydb.model.ReservedNodesOffering.ReadOnly = new Wrapper(impl)
}
