package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class FailoverShardRequest(clusterName: String, shardName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.FailoverShardRequest = {
    import FailoverShardRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.FailoverShardRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .shardName(shardName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.FailoverShardRequest.ReadOnly =
    zio.aws.memorydb.model.FailoverShardRequest.wrap(buildAwsValue())
}
object FailoverShardRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.FailoverShardRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.FailoverShardRequest =
      zio.aws.memorydb.model.FailoverShardRequest(clusterName, shardName)
    def clusterName: String
    def shardName: String
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getShardName: ZIO[Any, Nothing, String] = ZIO.succeed(shardName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.FailoverShardRequest
  ) extends zio.aws.memorydb.model.FailoverShardRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
    override val shardName: String = impl.shardName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.FailoverShardRequest
  ): zio.aws.memorydb.model.FailoverShardRequest.ReadOnly = new Wrapper(impl)
}
